document.addEventListener( 'DOMContentLoaded', function () {
    "use strict";

    // Select the OTP form
    var realhomesOtpForm = document.getElementById( 'ere-otp-verification-form' );

    if ( realhomesOtpForm ) {
        // Select all OTP input fields
        var otpInputs               = realhomesOtpForm.querySelectorAll( 'input[type="text"]' ),
            timerElement            = document.getElementById( 'otp-timer' ),
            countdownElement        = realhomesOtpForm.querySelector( '.countdown' ),
            countdownExpiredMessage = countdownElement.dataset.exipredMessage,
            cancelButton            = realhomesOtpForm.querySelector( 'button[name="ere_social_cancel_otp"]' ),
            homeUrl                 = cancelButton.dataset.otpHomeUrl;

        // Implement the focus navigation logic
        otpInputs.forEach( function ( input, index ) {
            input.addEventListener( 'input', function ( event ) {
                var value = event.target.value;

                // Ensure only one digit is entered
                if ( value.length > 1 ) {
                    event.target.value = value.charAt( 0 ); // Keep only the first character
                }

                // Move to the next field if not the last field and input is valid
                if ( value && index < otpInputs.length - 1 ) {
                    otpInputs[index + 1].focus();
                }
            } );

            input.addEventListener( 'keydown', function ( event ) {
                if ( event.key === 'Backspace' && input.value === '' && index > 0 ) {
                    otpInputs[index - 1].focus();
                }
            } );

            input.addEventListener( 'keypress', function ( event ) {
                var charCode = event.charCode || event.keyCode;
                if ( charCode < 48 || charCode > 57 ) {
                    event.preventDefault();
                }
            } );
        } );

        // Countdown timer for 5 minutes
        if ( timerElement ) {
            var timeRemaining = 5 * 60; // 10 minutes in seconds

            function updateTimerDisplay() {
                var minutes = Math.floor( timeRemaining / 60 );
                var seconds = timeRemaining % 60;

                // Format time as MM:SS
                timerElement.textContent =
                    ( minutes < 10 ? '0' : '' ) + minutes + ':' +
                    ( seconds < 10 ? '0' : '' ) + seconds;
            }

            function countdown() {
                if ( timeRemaining > 0 ) {
                    timeRemaining -= 1;
                    updateTimerDisplay();
                } else {
                    // Timer reached zero, handle expiration logic
                    alert( countdownExpiredMessage );
                    clearInterval( timerInterval );
                }
            }

            // Initialize and start the timer
            updateTimerDisplay();
            var timerInterval = setInterval( countdown, 1000 );
        }

        if ( cancelButton ) {
            cancelButton.addEventListener( 'click', function () {
                // Redirect to the home page
                window.location.href = homeUrl;
            } );
        }
    }
} );
