<?php
/**
 * Template Name: OTP Verification
 *
 * @since      4.3.7
 *
 * @subpackage common
 * @package    realhomes
 */

if ( isset( $_POST['ere_social_verify_otp'] ) ) {
	ere_verify_social_otp();
}

get_header();
?>
    <div class="otp-container">
        <div class="otp-box">
            <div class="logo-container">
				<?php
				$logo_path        = get_option( 'theme_sitelogo' );
				$retina_logo_path = get_option( 'theme_sitelogo_retina' );
				if ( ! empty( $logo_path ) || ! empty( $retina_logo_path ) ) {
					?>
                    <a class="site-logo" title="<?php bloginfo( 'name' ); ?>" href="<?php echo esc_url( home_url() ); ?>">
						<?php inspiry_logo_img( $logo_path, $retina_logo_path ); ?>
                    </a>
					<?php
				} else {
					?>
                    <h2 class="rh_logo__heading">
                        <a href="<?php echo esc_url( home_url() ); ?>" title="<?php bloginfo( 'name' ); ?>">
							<?php bloginfo( 'name' ); ?>
                        </a>
                    </h2>
					<?php
				}
				?>
            </div>

            <h2><?php esc_html_e( 'OTP Verification', 'framework' ); ?></h2>
            <p><?php esc_html_e( 'Please enter the OTP (One-Time Password) sent to your registered email/phone number to complete your verification.', 'framework' ); ?></p>

			<?php
			if ( ere_is_social_login_enabled( 'facebook' ) || ere_is_social_login_enabled( 'google' ) || ere_is_social_login_enabled( 'twitter' ) ) {
				ere_show_otp_form();
			} else {
				?>
                <p class="alert"><?php esc_html_e( 'Notice: Social login for any of the given services is not configured!', 'framework' ); ?></p>
				<?php
			}
			?>
        </div>
    </div>
<?php
get_footer();