<?php
/**
 * Owner post type and related stuff
 *
 * @since 2.2.9
 */

if ( ! function_exists( 'ere_register_owner_post_type' ) ) {
	/**
	 * Register owner custom post type
	 *
	 * @since 2.2.9
	 */
	function ere_register_owner_post_type() {

		$labels = array(
			'name'                  => esc_html_x( 'Owners', 'Post Type General Name', ERE_TEXT_DOMAIN ),
			'singular_name'         => esc_html_x( 'Owner', 'Post Type Singular Name', ERE_TEXT_DOMAIN ),
			'menu_name'             => esc_html__( 'Owners', ERE_TEXT_DOMAIN ),
			'name_admin_bar'        => esc_html__( 'Owner', ERE_TEXT_DOMAIN ),
			'archives'              => esc_html__( 'Owner Archives', ERE_TEXT_DOMAIN ),
			'attributes'            => esc_html__( 'Owner Attributes', ERE_TEXT_DOMAIN ),
			'parent_item_colon'     => esc_html__( 'Parent Owner:', ERE_TEXT_DOMAIN ),
			'all_items'             => esc_html__( 'All Owners', ERE_TEXT_DOMAIN ),
			'add_new_item'          => esc_html__( 'Add New Owner', ERE_TEXT_DOMAIN ),
			'add_new'               => esc_html__( 'Add New', ERE_TEXT_DOMAIN ),
			'new_item'              => esc_html__( 'New Owner', ERE_TEXT_DOMAIN ),
			'edit_item'             => esc_html__( 'Edit Owner', ERE_TEXT_DOMAIN ),
			'update_item'           => esc_html__( 'Update Owner', ERE_TEXT_DOMAIN ),
			'view_item'             => esc_html__( 'View Owner', ERE_TEXT_DOMAIN ),
			'view_items'            => esc_html__( 'View Owners', ERE_TEXT_DOMAIN ),
			'search_items'          => esc_html__( 'Search Owner', ERE_TEXT_DOMAIN ),
			'not_found'             => esc_html__( 'Not found', ERE_TEXT_DOMAIN ),
			'not_found_in_trash'    => esc_html__( 'Not found in Trash', ERE_TEXT_DOMAIN ),
			'featured_image'        => esc_html__( 'Featured Image', ERE_TEXT_DOMAIN ),
			'set_featured_image'    => esc_html__( 'Set featured image', ERE_TEXT_DOMAIN ),
			'remove_featured_image' => esc_html__( 'Remove featured image', ERE_TEXT_DOMAIN ),
			'use_featured_image'    => esc_html__( 'Use as featured image', ERE_TEXT_DOMAIN ),
			'insert_into_item'      => esc_html__( 'Insert into owner', ERE_TEXT_DOMAIN ),
			'uploaded_to_this_item' => esc_html__( 'Uploaded to this owner', ERE_TEXT_DOMAIN ),
			'items_list'            => esc_html__( 'Owners list', ERE_TEXT_DOMAIN ),
			'items_list_navigation' => esc_html__( 'Owners list navigation', ERE_TEXT_DOMAIN ),
			'filter_items_list'     => esc_html__( 'Filter owners list', ERE_TEXT_DOMAIN ),
		);
		$args   = array(
			'label'               => esc_html__( 'Owner', ERE_TEXT_DOMAIN ),
			'description'         => esc_html__( 'Owner custom post type for the properties to choose as contact and information provider.', ERE_TEXT_DOMAIN ),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'thumbnail' ),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => false,
			'menu_position'       => 5,
			'show_in_admin_bar'   => true,
			'show_in_nav_menus'   => true,
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => true,
			'publicly_queryable'  => false,
			'capability_type'     => 'post',
			'show_in_rest'        => true,
			'rest_base'           => apply_filters( 'ere_owner_rest_base', esc_html__( 'owners', ERE_TEXT_DOMAIN ) )
		);
		register_post_type( 'owner', $args );
	}

	add_action( 'init', 'ere_register_owner_post_type', 0 );
}


if ( ! function_exists( 'ere_add_owner_meta_boxes' ) ) {
	/**
	 * Register owner post type metaboxes
	 *
	 * @since 2.2.9
	 *
	 * @param $meta_boxes
	 *
	 * @return array|mixed|void
	 */
	function ere_add_owner_meta_boxes( $meta_boxes ) {

		$prefix = 'rvr_'; // keeping it rvr_ for backward compatibility as this post type was shifted from rvr_

		$meta_boxes[] = array(
			'id'     => 'owner-meta-box',
			'title'  => esc_html__( 'Owner Details', ERE_TEXT_DOMAIN ),
			'pages'  => array( 'owner' ),
			'fields' => array(
				array(
					'id'      => "{$prefix}owner_email",
					'name'    => esc_html__( 'Email', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_verification_status",
					'name'    => esc_html__( 'Verified Owner', ERE_TEXT_DOMAIN ),
					'type'    => 'radio',
					'std'     => '0',
					'options' => array(
						'1' => esc_html__( 'Yes', ERE_TEXT_DOMAIN ),
						'0' => esc_html__( 'No', ERE_TEXT_DOMAIN ),
					),
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_mobile",
					'name'    => esc_html__( 'Mobile', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_office_phone",
					'name'    => esc_html__( 'Office Phone', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_fax",
					'name'    => esc_html__( 'Fax', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_whatsapp",
					'name'    => esc_html__( 'Whatsapp', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_address",
					'name'    => esc_html__( 'Address', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_twitter",
					'name'    => esc_html__( 'Twitter Link', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_facebook",
					'name'    => esc_html__( 'Facebook Link', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_instagram",
					'name'    => esc_html__( 'Instagram Link', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_linkedin",
					'name'    => esc_html__( 'Linkedin Link', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_pinterest",
					'name'    => esc_html__( 'Pinterest Link', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
				array(
					'id'      => "{$prefix}owner_youtube",
					'name'    => esc_html__( 'Youtube Link', ERE_TEXT_DOMAIN ),
					'type'    => 'text',
					'columns' => 6,
				),
			)
		);

		return apply_filters( 'ere_owner_meta_boxes', $meta_boxes );
	}

	add_action( 'rwmb_meta_boxes', 'ere_add_owner_meta_boxes' );
}


if ( ! function_exists( 'ere_owner_edit_columns' ) ) {
	/**
	 * Custom columns for owners
	 *
	 * @since 2.2.9
	 *
	 * @param $columns
	 *
	 * @return array
	 */
	function ere_owner_edit_columns( $columns ) {

		$columns = array(
			'cb'            => '<input type="checkbox" />',
			'title'         => esc_html__( 'Name', ERE_TEXT_DOMAIN ),
			'owner_photo'   => esc_html__( 'Photo', ERE_TEXT_DOMAIN ),
			'owner_info'    => esc_html__( 'Owner Info', ERE_TEXT_DOMAIN ),
			'owner_address' => esc_html__( 'Address', ERE_TEXT_DOMAIN ),
			'date'          => esc_html__( 'Publish Time', ERE_TEXT_DOMAIN ),
		);

		/**
		 * WPML Support
		 */
		if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
			global $sitepress;
			$wpml_columns = new WPML_Custom_Columns( $sitepress );
			$columns      = $wpml_columns->add_posts_management_column( $columns );
		}

		/**
		 * Reverse the array for RTL
		 */
		if ( is_rtl() ) {
			$columns = array_reverse( $columns );
		}

		return $columns;
	}

	add_action( 'manage_edit-owner_columns', 'ere_owner_edit_columns' );
}


if ( ! function_exists( 'ere_set_owner_columns_values' ) ) {
	/**
	 * Setting owner columns values
	 *
	 * @since 2.2.9
	 *
	 * @param $column_name
	 */
	function ere_set_owner_columns_values( $column_name ) {

		global $post;

		$meta_data = get_post_custom( $post->ID );

		switch ( $column_name ) {

			case 'owner_photo':
				if ( has_post_thumbnail( $post->ID ) ) {
					echo get_the_post_thumbnail( $post->ID, array( 64, 64 ) );
				} else if ( isset( $meta_data['rvr_owner_email'][0] ) ) {
					echo get_avatar( $meta_data['rvr_owner_email'][0], 64 );
				} else {
					echo get_avatar( '', 64 );
				}
				break;
			case 'owner_info':
				$not_available = true;

				if ( ! empty( $meta_data['rvr_owner_email'] ) ) {
					echo sprintf( '<strong>%s</strong> ', esc_html__( 'Email:', ERE_TEXT_DOMAIN ) ) . $meta_data['rvr_owner_email'][0] . '<br>';
					$not_available = false;
				}
				if ( ! empty( $meta_data['rvr_owner_mobile'] ) ) {
					echo sprintf( '<strong>%s</strong> ', esc_html__( 'Mobile: ', ERE_TEXT_DOMAIN ) ) . $meta_data['rvr_owner_mobile'][0] . '<br>';
					$not_available = false;
				}
				if ( ! empty( $meta_data['rvr_owner_whatsapp'] ) ) {
					echo sprintf( '<strong>%s</strong> ', esc_html__( 'Whatsapp: ', ERE_TEXT_DOMAIN ) ) . $meta_data['rvr_owner_whatsapp'][0];
					$not_available = false;
				}
				if ( $not_available ) {
					esc_html_e( 'NA', ERE_TEXT_DOMAIN );
				}
				break;
			case 'owner_address':
				echo ( ! empty( $meta_data['rvr_owner_address'] ) ) ? $meta_data['rvr_owner_address'][0] : esc_html__( 'NA', ERE_TEXT_DOMAIN );
				break;
			default:
				break;
		}
	}

	add_action( 'manage_posts_custom_column', 'ere_set_owner_columns_values' );
}
