<?php
/**
 * ERE settings ajax request handlers
 *
 * @since 2.3.2
*/

// Post type settings
if ( ! function_exists( 'ere_post_type_settings_update' ) ) {
	/**
	 * Handler function for post type ERE options AJAX request.
	 *
	 * @since 2.3.2
	 */
	function ere_post_type_settings_update() {

		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json_error( array(
				'message' => esc_html__( 'Permission denied.', ERE_TEXT_DOMAIN ),
			) );
		}

		if ( ! isset( $_POST['_wpnonce'] ) || ! wp_verify_nonce( $_POST['_wpnonce'], 'inspiry_ere_settings' ) ) {
			wp_send_json_error( array(
				'message' => esc_html__( 'Nonce verification failed.', ERE_TEXT_DOMAIN ),
			) );
		}

		// Optional: check if needed
		if ( empty( $_POST['ptSettings'] ) ) {
			wp_send_json_error( array(
				'message' => esc_html__( 'Incorrect data supplied.', ERE_TEXT_DOMAIN ),
			) );
		}

		$options = array(
			'ere_agent_post_type_status',
			'ere_agency_post_type_status',
			'ere_owner_post_type_status',
			'ere_partner_post_type_status',
			'ere_slides_post_type_status',
			'inspiry_property_slug',
			'inspiry_agent_slug',
			'ere_agent_location_slug',
			'inspiry_agency_slug',
			'ere_agency_location_slug',
			'inspiry_property_city_slug',
			'inspiry_property_status_slug',
			'inspiry_property_type_slug',
			'inspiry_property_feature_slug',
		);

		foreach ( $options as $option_name ) {
			if ( isset( $_POST[ $option_name ] ) ) {
				update_option( $option_name, sanitize_text_field( $_POST[ $option_name ] ) );
			}
		}

		wp_send_json_success( array(
			'message' => esc_html__( 'Settings saved successfully.', ERE_TEXT_DOMAIN ),
		) );
	}

	add_action( 'wp_ajax_ere_post_type_settings_update', 'ere_post_type_settings_update' );
}
