<?php
if ( ! function_exists( 'ere_update_user_id_in_property_views' ) ) {
	/**
	 * Update property views with the logged-in user's ID.
	 *
	 * @since 2.2.6
	 */
	function ere_update_user_id_in_property_views() {
		// Verify nonce for security
		if ( empty( $_POST['nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'ere-property-analytics' ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Invalid nonce.', ERE_TEXT_DOMAIN ) ) );
		}

		// Check if RIDs and user ID are provided
		$rids    = isset( $_POST['rids'] ) ? (array)$_POST['rids'] : array();
		$user_id = isset( $_POST['user_id'] ) ? absint( $_POST['user_id'] ) : 0;

		if ( empty( $rids ) || $user_id === 0 ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Invalid data provided.', ERE_TEXT_DOMAIN ) ) );
		}

		global $wpdb;
		$table_name = $wpdb->prefix . 'inspiry_property_analytics';

		// Update each RID with the user ID
		$placeholders = implode( ', ', array_fill( 0, count( $rids ), '%d' ) );
		$sql_query    = $wpdb->prepare(
			"UPDATE $table_name SET Property_Viewer_ID = %d WHERE RID IN ($placeholders)",
			array_merge( array( $user_id ), $rids )
		);

		$result = $wpdb->query( $sql_query );

		if ( $result !== false ) {
			wp_send_json_success( array( 'message' => esc_html__( 'Property views updated successfully.', ERE_TEXT_DOMAIN ) ) );
		} else {
			wp_send_json_error( array( 'message' => esc_html__( 'Failed to update property views.', ERE_TEXT_DOMAIN ) ) );
		}
	}

	add_action( 'wp_ajax_ere_update_user_id_in_property_views', 'ere_update_user_id_in_property_views' );
}