<?php
if ( has_term( '', 'property-status', get_the_ID() ) ) {

	global $settings;
	$repeater_status    = $settings['rhea_property_status_select'];
	$status_terms       = get_the_terms( get_the_ID(), 'property-status' );
	$first_status_slug  = $status_terms[0]->slug;
	$first_status_name  = $status_terms[0]->name;
	$status_classes     = 'property-status-' . $first_status_slug;
	$this_status_bg     = '';
	$this_status_colors = '';
	foreach ( $repeater_status as $status ) {

		if ( $status['rhea_property_status_select_section'] == $first_status_slug ) {

			if ( $status['rhea_get_terms_bg'] ) {
				$this_status_bg = $status['rhea_get_terms_bg'];
			}
			if ( $status['rhea_get_terms_colors'] ) {
				$this_status_colors = $status['rhea_get_terms_colors'];
			}
		}
	}
	?>
    <div class="rhea_soi_prop_status_sty">
		<?php
		// Prepare inline styles safely
		$style = '';
		if ( ! empty( $this_status_bg ) ) {
			$style .= sprintf( 'background: %s;', esc_attr( $this_status_bg ) );
		}
		if ( ! empty( $this_status_colors ) ) {
			$style .= sprintf( ' color: %s;', esc_attr( $this_status_colors ) );
		}
		?>
        <span class="rhea_prop_status_sty <?php echo esc_attr( $status_classes ); ?>" <?php echo ! empty( $style ) ? sprintf( 'style="%s"', trim( $style ) ) : ''; ?>>
            <?php echo esc_html( $first_status_name ); ?>
        </span>
    </div>
	<?php
}
?>