<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Agents_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'ere-agents-widget';
	}

	public function get_title() {
		return esc_html__( 'RH: Agents V1 (Grid)', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-person rh-modern-widget';
	}

	public function get_keywords() {
		return [ 'RealHomes', 'Modern', 'Agents Grid' ];
	}

	public function get_categories() {
		return [ 'real-homes' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'agents_section',
			[
				'label' => esc_html__( 'Agents', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'rhea_agent_variations',
			array(
				'label'   => esc_html__( 'Designs', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => array(
					'default'   => array(
						'title' => esc_html__( 'Default', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-gallery-grid',
					),
					'style-two' => array(
						'title' => esc_html__( 'Style Two', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-column',
					),
				),
				'default' => 'default',
				'toggle'  => false,
			)
		);

		$this->add_responsive_control(
			'property_grid_layout',
			[
				'label'       => esc_html__( 'Layout', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Number of columns will be reduced automatically if parent container has insufficient width.', RHEA_TEXT_DOMAIN ) . '<br>' .
				                 esc_html__( '* Make sure "Style -> Agent Width" field is empty.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '25%',
				'options'     => array(
					'25%'     => esc_html__( '4 Columns', RHEA_TEXT_DOMAIN ),
					'33.333%' => esc_html__( '3 Columns', RHEA_TEXT_DOMAIN ),
					'50%'     => esc_html__( '2 Columns', RHEA_TEXT_DOMAIN ),
					'100%'    => esc_html__( '1 Column', RHEA_TEXT_DOMAIN ),
				),
				'selectors'   => [
					'{{WRAPPER}} .rh_agent_elementor' => 'width: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'number_of_agents',
			[
				'label'   => esc_html__( 'Number of Agents', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'default' => 4,
			]
		);

		$this->add_control(
			'agent_agency_name',
			[
				'label'        => esc_html__( 'Agency Name', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'agent_mobile_number',
			[
				'label'        => esc_html__( 'Mobile Number', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'agent_office_number',
			[
				'label'        => esc_html__( 'Office Number', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'agent_whatsapp_number',
			[
				'label'        => esc_html__( 'Whatsapp Number', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'agent_fax_number',
			[
				'label'        => esc_html__( 'Fax Number', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'agent_license',
			[
				'label'        => esc_html__( 'License', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'agent_website',
			[
				'label'        => esc_html__( 'Website', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'agent_email',
			[
				'label'        => esc_html__( 'Email', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'properties_count',
			[
				'label'        => esc_html__( 'Properties Count', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'social_icons',
			[
				'label'        => esc_html__( 'Social Icons', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'meta_icons',
			[
				'label'        => esc_html__( 'Meta Icons', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'show_verification_badge',
			[
				'label'        => esc_html__( 'Show Verification Badge', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'display_arrow',
			[
				'label'        => esc_html__( 'Animation Arrow on Hover', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'Hide', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label'        => esc_html__( 'Show Pagination', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'agents_section_typography',
			[
				'label' => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_title_typography',
				'label'    => esc_html__( 'Title', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_agent_elementor .rh_agent__details h3 a',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_agency_typography',
				'label'    => esc_html__( 'Agency', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__agency a'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_number_typography',
				'label'    => esc_html__( 'Numbers', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '
				            {{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__info.number,
				            {{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__info.number a
				            '
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_website_typography',
				'label'    => esc_html__( 'Website', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__info.website a'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_email_typography',
				'label'    => esc_html__( 'Email', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__email',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_figure_typography',
				'label'    => esc_html__( 'Listed Figure', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__listed .figure',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_label_typography',
				'label'    => esc_html__( 'Listed Label', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__listed .heading',
			]
		);

		$this->add_responsive_control(
			'agent_social_icon_size',
			[
				'label'     => esc_html__( 'Meta Icons Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 90
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh_section__agents_elementor .rh_agent_elementor .rh_agent__details .rh_agent__social_icons a i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rh_section__agents_elementor .rh_agent_elementor .rh_agent__details .rh_agent__social_icons a svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
				'reset'     => true
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_pagination',
			[
				'label'     => esc_html__( 'Pagination', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'show_pagination' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_margin',
			[
				'label'      => esc_html__( 'Container Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-ultra-properties-pagination .pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_padding',
			[
				'label'      => esc_html__( 'Container Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-ultra-properties-pagination .pagination' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_items_padding',
			[
				'label'      => esc_html__( 'Items Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-ultra-properties-pagination .pagination a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_items_spacing',
			[
				'label'     => esc_html__( 'Items Spacing', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-properties-pagination .pagination' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_items_border_radius',
			[
				'label'      => esc_html__( 'Items Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rhea-ultra-properties-pagination .pagination a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'pagination_items_text_color',
			[
				'label'     => esc_html__( 'Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-properties-pagination .pagination a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'pagination_items_text_hover_color',
			[
				'label'     => esc_html__( 'Text Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-properties-pagination .pagination a:hover, {{WRAPPER}} .rhea-ultra-properties-pagination .pagination a.current' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'pagination_items_bg_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-properties-pagination .pagination a' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'pagination_items_bg_hover_color',
			[
				'label'     => esc_html__( 'Background Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-properties-pagination .pagination a:hover, {{WRAPPER}} .rhea-ultra-properties-pagination .pagination a.current' => 'background: {{VALUE}}'
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pagination_items_box_shadow',
				'label'    => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-ultra-properties-pagination .pagination a',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'pagination_items_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-ultra-properties-pagination .pagination a',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'agent_styles_sizes',
			[
				'label' => esc_html__( 'Size And Position', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'agent_width',
			[
				'label'       => esc_html__( 'Agent Width (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'This will over-ride the width of "Content -> Layout"', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'range'       => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rh_agent_elementor' => 'width: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'agent_thumb_position',
			[
				'label'           => esc_html__( 'Thumbnail Vertical Position (px)', RHEA_TEXT_DOMAIN ),
				'type'            => \Elementor\Controls_Manager::SLIDER,
				'range'           => [
					'px' => [
						'min' => 0,
						'max' => 160,
					],
				],
				'desktop_default' => [
					'size' => 40,
					'unit' => 'px',
				],
				'selectors'       => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__thumbnail' => 'margin-top: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rh_agent'                                => 'padding-top: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'agents_spacing_section',
			[
				'label' => esc_html__( 'Spacings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'agent_card_padding',
			[
				'label'      => esc_html__( 'Agent Card Inner Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_agent__wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->add_responsive_control(
			'agent_vertical_spacings',
			[
				'label'     => esc_html__( 'Vertical Space between Agents (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_section__agents_elementor .rh_agent_elementor' => 'padding-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'agent_title_spacings_top',
			[
				'label'     => esc_html__( 'Agent Title Margin Top (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_agent__details h3' => 'margin-top: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'agent_title_spacings_bottom',
			[
				'label'     => esc_html__( 'Agent Title Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_agent__details h3' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'agency_margin_bottom',
			[
				'label'     => esc_html__( 'Agency Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_agent__agency' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'agent_number_spacings',
			[
				'label'     => esc_html__( 'Agent Numbers Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_agent__details .rh_agent__info.number' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'agent_website_spacings',
			[
				'label'     => esc_html__( 'Agent Website Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_agent__details .rh_agent__info.website' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'agent_email_spacings',
			[
				'label'     => esc_html__( 'Agent Email Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_agent__email' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'agent_figure_spacings',
			[
				'label'     => esc_html__( 'Listed Figure Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_agent__listed .figure' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'agent_listed_properties_spacings',
			[
				'label'     => esc_html__( 'Listed Properties Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_agent__listed .heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'agent_social_middle_spacings',
			[
				'label'     => esc_html__( 'Social Icons horizontal spacing (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_agent__social_icons li' => 'margin: 0 {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'agent_styles',
			[
				'label' => esc_html__( 'Agent Colors', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'agent_bg_color',
			[
				'label'     => esc_html__( 'Agent Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__wrap' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent_title_color',
			[
				'label'     => esc_html__( 'Title', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details h3 a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_title_hover_color',
			[
				'label'     => esc_html__( 'Title Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details h3 a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_verficiation_badge_bg_color_hover',
			[
				'label'     => esc_html__( 'Verification Badge Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#1cb2ff',
				'selectors' => [
					'{{WRAPPER}} .rh_agent__details h3 .rh_agent_verification__icon' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_verficiation_badge_svg_color_hover',
			[
				'label'     => esc_html__( 'Verification Badge Icon Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .rh_agent__details h3 .rh_agent_verification__icon svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_agency_color',
			[
				'label'     => esc_html__( 'Agency', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__agency a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_agency_hover_color',
			[
				'label'     => esc_html__( 'Agency Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__agency a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_numbers_color',
			[
				'label'     => esc_html__( 'Numbers', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__info.number a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__info.number'   => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_control(
			'agent_numbers_hover_color',
			[
				'label'     => esc_html__( 'Numbers Link Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__info.number a:hover' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'agent_website_color',
			[
				'label'     => esc_html__( 'Website', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__info.website a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_website_hover_color',
			[
				'label'     => esc_html__( 'Website Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__info.website a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_email_color',
			[
				'label'     => esc_html__( 'Email', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__email' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'agent_email_hover_color',
			[
				'label'     => esc_html__( 'Email Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__email:hover' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'agent_figure_color',
			[
				'label'     => esc_html__( 'Listed Figure', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__listed .figure' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_listed_figure_color',
			[
				'label'     => esc_html__( 'Listed Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__listed .heading' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_social_icons_color',
			[
				'label'     => esc_html__( 'Social Icons', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__social_icons li a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_social_icons_hover',
			[
				'label'     => esc_html__( 'Social Icons Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__details .rh_agent__social_icons li a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_arrow_circle',
			[
				'label'     => esc_html__( 'Arrow Circle Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__arrow .cls-1' => 'fill: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'agent_arrow',
			[
				'label'     => esc_html__( 'Arrow Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_agent_elementor .rh_agent__arrow .cls-2' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'agent_box_shadow',
			[
				'label' => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'label'    => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh_section__agents_elementor .rh_agent_elementor .rh_agent__wrap',
			]
		);


		$this->end_controls_section();

	}

	protected function render() {

		$settings                   = $this->get_settings_for_display();
		$display_verification_badge = $settings['show_verification_badge'];

		// Number of agents
		if ( ! $settings['number_of_agents'] ) {
			$settings['number_of_agents'] = 4;
		}

		$paged = 1;
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} else if ( get_query_var( 'page' ) ) { // if is static front page
			$paged = get_query_var( 'page' );
		}

		$agents_args = array(
			'post_type'      => 'agent',
			'posts_per_page' => $settings['number_of_agents'],
			'paged'          => $paged,
		);

		$agents_query = new WP_Query( apply_filters( 'rhea_modern_agents_widget', $agents_args ) );

		if ( $agents_query->have_posts() ) {
			?>
            <div class="rh_elementor_widget rh_wrapper__agents_elementor <?php echo esc_attr( $settings['rhea_agent_variations'] ); ?>">
                <div class="rh_section__agents_elementor">
					<?php
					while ( $agents_query->have_posts() ) {
						$agents_query->the_post();
                        $agent_id = get_the_ID();
						$agent_mobile        = get_post_meta( $agent_id, 'REAL_HOMES_mobile_number', true );
						$agent_email         = get_post_meta( $agent_id, 'REAL_HOMES_agent_email', true );
						$verification_status = get_post_meta( $agent_id, 'ere_agent_verification_status', true );

						if ( $settings['agent_agency_name'] === 'yes' ) {
							$agent_agency_ID = get_post_meta( $agent_id, 'REAL_HOMES_agency', true );
							if ( $agent_agency_ID > 0 ) {
								$agent_agency_name      = get_the_title( $agent_agency_ID );
								$agent_agency_permalink = get_permalink( $agent_agency_ID );
							}
						}

						if ( $settings['agent_mobile_number'] === 'yes' ) {
							$agent_mobile = get_post_meta( $agent_id, 'REAL_HOMES_mobile_number', true );
						}

						if ( $settings['agent_office_number'] === 'yes' ) {
							$agent_office_number = get_post_meta( $agent_id, 'REAL_HOMES_office_number', true );
						}

						if ( $settings['agent_whatsapp_number'] === 'yes' ) {
							$agent_whatsapp = get_post_meta( $agent_id, 'REAL_HOMES_whatsapp_number', true );
						}

						if ( $settings['agent_fax_number'] === 'yes' ) {
							$agent_fax_number = get_post_meta( $agent_id, 'REAL_HOMES_fax_number', true );
						}

						if ( $settings['agent_website'] === 'yes' ) {
							$agent_website = get_post_meta( $agent_id, 'REAL_HOMES_website', true );
						}

						if ( $settings['agent_license'] === 'yes' ) {
							$agent_license = get_post_meta( $agent_id, 'REAL_HOMES_license_number', true );
						}

						if ( $settings['agent_email'] === 'yes' ) {
							$agent_email = get_post_meta( $agent_id, 'REAL_HOMES_agent_email', true );
						}

						if ( $settings['meta_icons'] === 'yes' ) {
							$info_icons = true;
						} else {
							$info_icons = false;
						}

						if ( function_exists( 'ere_get_agent_properties_count' ) ) {
							$listed_properties = ere_get_agent_properties_count( $agent_id );
						}
						?>
                        <article <?php post_class( 'rh_agent_elementor' ); ?>>
                            <div class="rh_agent__wrap">
                                <div class="rh_agent__thumbnail">
                                    <a href="<?php the_permalink(); ?>">
										<?php
										if ( has_post_thumbnail() ) {
											if ( ! empty( $settings['agent_thumb_sizes_select'] ) ) {
												the_post_thumbnail( $settings['agent_thumb_sizes_select'] );
											} else {
												the_post_thumbnail( 'agent-image' );
											}
										}
										?>
                                    </a>
                                </div>

                                <div class="rh_agent__details">

                                    <h3>
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        <?php
                                        if ( 'yes' === $display_verification_badge && $verification_status ) {
                                            ?>
                                            <span class="rh_agent_verification__icon">
                                                <?php
                                                inspiry_safe_include_svg( '/icons/verified-check.svg', '/common/images' );
                                                ?>
                                            </span>
                                            <?php
                                        }
                                        ?>
                                    </h3>

                                    <?php
                                    if ( ! empty( $agent_agency_name ) ) {
                                        ?>
                                        <p class="rh_agent__agency">
                                            <a href="<?php echo esc_url( $agent_agency_permalink ); ?>">
                                                <?php echo esc_html( $agent_agency_name ); ?>
                                            </a>
                                        </p>
                                        <?php
                                    }

                                    if ( ! empty( $agent_mobile ) ) {
                                        ?>
                                        <p class="rh_agent__info phone number">
                                            <a href="tel:<?php echo esc_attr( $agent_mobile ); ?>">
                                                <?php echo ( $info_icons ) ? '<i class="fas fa-mobile-alt"></i>&nbsp;' : ''; ?>
                                                <?php echo esc_html( $agent_mobile ); ?>
                                            </a>
                                        </p>
                                        <?php
                                    }

                                    if ( ! empty( $agent_office_number ) ) {
                                        ?>
                                        <p class="rh_agent__info phone number">
                                            <a href="tel:<?php echo esc_attr( $agent_office_number ); ?>">
                                                <?php echo ( $info_icons ) ? '<i class="fas fa-phone"></i>&nbsp;' : ''; ?>
                                                <?php echo esc_html( $agent_office_number ); ?>
                                            </a>
                                        </p>
                                        <?php
                                    }

                                    if ( ! empty( $agent_whatsapp ) ) {
                                        $agent_whatsapp_link = 'https://wa.me/' . str_replace( '-', '', $agent_whatsapp );
                                        ?>
                                        <p class="rh_agent__info whatsapp number">
                                            <a href="<?php echo esc_url( $agent_whatsapp_link ); ?>" target="_blank">
                                                <?php echo ( $info_icons ) ? '<i class="fab fa-whatsapp"></i>&nbsp;' : ''; ?>
                                                <?php echo esc_html( $agent_whatsapp ); ?>
                                            </a>
                                        </p>
                                        <?php
                                    }

                                    if ( ! empty( $agent_fax_number ) ) {
                                        ?>
                                        <p class="rh_agent__info fax number">
                                            <a href="fax:<?php echo esc_attr( $agent_fax_number ); ?>">
                                                <?php echo ( $info_icons ) ? '<i class="fas fa-fax"></i>&nbsp;' : ''; ?>
                                                <?php echo esc_html( $agent_fax_number ); ?>
                                            </a>
                                        </p>
                                        <?php
                                    }

                                    if ( ! empty( $agent_license ) ) {
                                        ?>
                                        <p class="rh_agent__info license number">
                                            <?php echo ( $info_icons ) ? '<i class="fas fa-id-card"></i>&nbsp;' : ''; ?>
                                            <?php echo esc_html( $agent_license ); ?>
                                        </p>
                                        <?php
                                    }

                                    if ( ! empty( $agent_website ) ) {
                                        ?>
                                        <p class="rh_agent__info website">
                                            <a href="<?php echo esc_url( $agent_website ); ?>" target="_blank">
                                                <?php echo ( $info_icons ) ? '<i class="fas fa-link"></i> &nbsp;' : ''; ?>
                                                <?php echo esc_url( $agent_website ); ?>
                                            </a>
                                        </p>
                                        <?php
                                    }

                                    if ( ! empty( $agent_email ) ) {
                                        ?>
                                        <a href="mailto:<?php echo esc_attr( antispambot( $agent_email ) ); ?>"
                                           class="rh_agent__email">
                                            <?php echo ( $info_icons ) ? '<i class="fas fa-envelope"></i>&nbsp;' : ''; ?>
                                            <?php echo esc_html( antispambot( $agent_email ) ); ?>
                                        </a>
                                        <?php
                                    }

                                    if (
                                        ! empty( $listed_properties ) &&
                                        $listed_properties > 0 &&
                                        $settings['properties_count'] === 'yes'
                                    ) {
                                        ?>
                                        <div class="rh_agent__listed">
                                            <p class="figure"><?php echo esc_html( $listed_properties ); ?></p>
                                            <p class="heading"><?php echo ( 1 === $listed_properties ) ? esc_html__( 'Listed Property', RHEA_TEXT_DOMAIN ) : esc_html__( 'Listed Properties', RHEA_TEXT_DOMAIN ); ?></p>
                                        </div>
                                        <?php
                                    }

                                    if ( $settings['social_icons'] === 'yes' ) {
                                        $facebook  = get_post_meta( $agent_id, 'REAL_HOMES_facebook_url', true );
                                        $twitter   = get_post_meta( $agent_id, 'REAL_HOMES_twitter_url', true );
                                        $linkedin  = get_post_meta( $agent_id, 'REAL_HOMES_linked_in_url', true );
                                        $instagram = get_post_meta( $agent_id, 'inspiry_instagram_url', true );
                                        $pinterest = get_post_meta( $agent_id, 'inspiry_pinterest_url', true );
                                        $youtube   = get_post_meta( $agent_id, 'inspiry_youtube_url', true );
                                        ?>
                                        <ul class="rh_agent__social_icons">
                                            <?php
                                            if ( ! empty( $facebook ) ) {
                                                ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $facebook ); ?>" target="_blank">
                                                        <i class="fab fa-facebook"></i>
                                                    </a>
                                                </li>
                                                <?php
                                            }

                                            if ( ! empty( $twitter ) ) {
                                                ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $twitter ); ?>" target="_blank">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" fill="currentColor" viewBox="0 0 16 16"><path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z"></path></svg>
                                                    </a>
                                                </li>
                                                <?php
                                            }

                                            if ( ! empty( $linkedin ) ) {
                                                ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $linkedin ); ?>" target="_blank">
                                                        <i class="fab fa-linkedin"></i>
                                                    </a>
                                                </li>
                                                <?php
                                            }

                                            if ( ! empty( $instagram ) ) {
                                                ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $instagram ); ?>" target="_blank">
                                                        <i class="fab fa-instagram"></i>
                                                    </a>
                                                </li>
                                                <?php
                                            }

                                            if ( ! empty( $pinterest ) ) {
                                                ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $pinterest ); ?>" target="_blank">
                                                        <i class="fab fa-pinterest"></i>
                                                    </a>
                                                </li>
                                                <?php
                                            }

                                            if ( ! empty( $youtube ) ) {
                                                ?>
                                                <li>
                                                    <a href="<?php echo esc_url( $youtube ); ?>" target="_blank">
                                                        <i class="fab fa-youtube"></i>
                                                    </a>
                                                </li>
                                                <?php
                                            }
                                            ?>
                                        </ul>
                                        <?php
                                    }

                                    if ( 'yes' == $settings['display_arrow'] ) {
                                        ?>
                                        <span class="rh_agent__arrow">
                                            <a href="<?php the_permalink(); ?>"><?php include( RHEA_ASSETS_DIR . '/icons/arrow-right.svg' ); ?></a>
										</span>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </article>
						<?php
					}
                    
					wp_reset_postdata();
	                ?>
                </div>
	            <?php
	            if ( 'yes' == $settings['show_pagination'] ) {
		            RHEA_ajax_pagination( $agents_query->max_num_pages, $agents_query, 'rhea-ultra-properties-pagination rhea-ultra-properties-container' );
	            }
	            ?>
            </div>
			<?php
		}

	}

}