<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_CTA_Three_Widget extends \Elementor\Widget_Base {
	public function get_name() {
		return 'ere-cta-three-widget';
	}

	public function get_title() {
		return esc_html__( 'RH: Call to Action 3', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-posts-ticker rh-modern-widget';
	}

	public function get_categories() {
		return [ 'real-homes' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Call to Action ', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'cta_top_title',
			[
				'label'   => esc_html__( 'Top Title', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXTAREA,
				'rows'    => 3,
				'default' => esc_html__( 'Find Great Places to Stay at Your Favorite Destinations', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'cta_main_description',
			[
				'label'   => esc_html__( 'Description', RHEA_TEXT_DOMAIN ),
				'description'     => esc_html__( 'You can use span, a, em, br, strong tags in text', RHEA_TEXT_DOMAIN ),

				'type'    => \Elementor\Controls_Manager::TEXTAREA,
				'rows'    => 8,
				'default' => esc_html__( 'Our rentals offer comfort with world class facilities to travellers around the globe. Explore best place to stay around your favorite destination and get great deals.', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'cta__btn_title',
			[
				'label'   => esc_html__( 'Button Title', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Explore Rentals', RHEA_TEXT_DOMAIN ),
				'separator'     => 'before',
			]
		);

		$this->add_control(
			'cta_btn_url',
			[
				'label'         => esc_html__( 'Button URL', RHEA_TEXT_DOMAIN ),
				'type'          => \Elementor\Controls_Manager::URL,
				'show_external' => true,
				'dynamic'       => [
					'active' => true,
				],
				'default'       => [
					'url' => '#',
				],
				'separator'     => 'after',
			]
		);

		$this->add_control(
			'ere_show_bg_image',
			[
				'label'        => esc_html__( 'Enable Background Image', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'cta_1_image',
			[
				'label'     => esc_html__( 'Background Image', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'default'   => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'ere_show_bg_image' => 'yes',
				],
			]
		);

		$this->add_control(
			'ere_cta_1_image_bg_size',
			[
				'label'     => esc_html__( 'Background Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'auto',
				'condition' => [
					'ere_show_bg_image' => 'yes',
				],
				'options'   => array(
					'cover'   => esc_html__( 'Cover', RHEA_TEXT_DOMAIN ),
					'contain' => esc_html__( 'Contain', RHEA_TEXT_DOMAIN ),
					'auto'    => esc_html__( 'Auto', RHEA_TEXT_DOMAIN ),
				)
			]
		);


		$this->add_control(
			'ere_enable_parallax_effect',
			[
				'label'        => esc_html__( 'Enable Parallax Effect', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'ere_show_bg_image' => 'yes',
				],
			]
		);

		$this->add_control(
			'ere_enable_overlay',
			[
				'label'        => esc_html__( 'Enable Background Overlay', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'ere_cta3_typo_section',
			[
				'label' => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'top_title_typography',
				'label'    => esc_html__( 'Top Title', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_label_cta_3',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'main_desc_typography',
				'label'    => esc_html__( 'Description', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .wrapper_content_cta_3 .rhea_description_cta_3 p',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'button_typography',
				'label'    => esc_html__( 'Button', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .cta_three_elementor_button',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'ere_cta3_layout_section',
			[
				'label' => esc_html__( 'Layout', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'ere_cta_container_padding',
			[
				'label'      => esc_html__( 'Container Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_section__cta_elementor_three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'ere_cta_max-width',
			[
				'label'           => esc_html__( 'Container Fluid Max Width (px)', RHEA_TEXT_DOMAIN ),
				'type'            => \Elementor\Controls_Manager::SLIDER,
				'range'           => [
					'px' => [
						'min' => 320,
						'max' => 2500,
					],
				],
				'desktop_default' => [
					'size' => 1240,
					'unit' => 'px',
				],
				'selectors'       => [
					'{{WRAPPER}} .wrapper_content_cta_3_box' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->add_control(
			'cta_flip_image',
			[
				'label'        => esc_html__( 'Flip Background Image?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'flip_content_cta',
			[
				'label'        => esc_html__( 'Flip Content Side?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);


		$this->add_responsive_control(
			'ere_cta_content_max-width',
			[
				'label'           => esc_html__( 'Content Side Max Width (%)', RHEA_TEXT_DOMAIN ),
				'type'            => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%','px' ],
				'range'           => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'desktop_default' => [
					'size' => 50,
					'unit' => '%',
				],
				'mobile_default'  => [
					'size' => 100,
					'unit' => '%',
				],
				'selectors'       => [
					'{{WRAPPER}} .wrapper_content_cta_3' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'ere_cta_content_padding',
			[
				'label'      => esc_html__( 'Content Inner Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .wrapper_content_cta_3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'ere_cta_label_margin',
			[
				'label'           => esc_html__( 'Top Label Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'            => \Elementor\Controls_Manager::SLIDER,
				'range'           => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'       => [
					'{{WRAPPER}} .wrapper_content_cta_3 .rhea_label_cta_3' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'ere_cta_main_desc_margin',
			[
				'label'           => esc_html__( 'Description Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'            => \Elementor\Controls_Manager::SLIDER,
				'range'           => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'       => [
					'{{WRAPPER}} .wrapper_content_cta_3 .rhea_description_cta_3 p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->add_responsive_control(
			'ere_cta_button_padding',
			[
				'label'      => esc_html__( 'Button Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .cta_three_elementor_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'rhea_cta_align',
			[
				'label'   => esc_html__( 'Text Align', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'initial'         => [
						'title' => esc_html__( 'Left', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-left',
					],
					'center'   => [
						'title' => esc_html__( 'Center', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'toggle'  => true,
			]
		);


		$this->end_controls_section();
		$this->start_controls_section(
			'cta3_colors',
			[
				'label' => esc_html__( 'Colors', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'cta_bg_section',
			[
				'label'     => esc_html__( 'Background', RHEA_TEXT_DOMAIN ),
				'description'     => esc_html__( 'If no image is set for background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_section__cta_elementor_three' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'cta_overlay',
			[
				'label'     => esc_html__( 'overlay Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_overlay_cta_3' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'cta_content_color',
			[
				'label'     => esc_html__( 'Content Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .wrapper_content_cta_3' => 'background: {{VALUE}}',
				],
			]
		);



		$this->add_control(
			'cta_top_label',
			[
				'label'     => esc_html__( 'Top Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_label_cta_3' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'cta_desc_color',
			[
				'label'     => esc_html__( 'Description', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .wrapper_content_cta_3 .rhea_description_cta_3 p' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'ere_first_button_color',
			[
				'label'     => esc_html__( 'Button Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cta_three_elementor_button' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'ere_first_button_hover_color',
			[
				'label'     => esc_html__( 'Button Text Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cta_three_elementor_button:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'ere_first_button_bg_color',
			[
				'label'     => esc_html__( 'Button Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cta_three_elementor_button' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'ere_first_button_bg_hover_color',
			[
				'label'     => esc_html__( 'Button Background Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cta_three_elementor_button:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings     = $this->get_settings_for_display();
		$allowed_html = array(
			'a'      => array(
				'href'   => array(),
				'title'  => array(),
				'target' => array(),
                'style' => array(),
 			),
			'br'     => array(),
			'em'     => array(),
			'strong' => array(
				'style' => array(),
            ),
			'span' => array(
				'style' => array(),
            ),
			'i' => array(
				'style' => array(),
            ),
		);
		?>


		<?php
		$flip_content_cta = '';
		if( 'yes' == $settings['flip_content_cta']){
			$flip_content_cta = ' rhea_flip_content_cta';
		}

		$cta_flip_image = '';
		if( 'yes' == $settings['cta_flip_image']){
			$cta_flip_image = ' rhea_cta_flip_image';
		}
		?>

        <section
                class="rh_elementor_widget rh_section__cta_elementor_three rh_cta--featured_elementor
<?php echo esc_attr($flip_content_cta); ?> ">

            <div class="rh_bg_cta_three
    <?php
            if ( $settings['ere_enable_parallax_effect'] == 'yes' ) {
	            echo esc_attr( 'ere_cta_parallax' );
            }
            echo esc_attr($cta_flip_image);
            ?>"
                 <?php if ( ! empty( $settings['cta_1_image']['id'] ) ) { ?>
                 style="background-size: <?php echo esc_attr( $settings['ere_cta_1_image_bg_size'] ); ?>; background-image: url(<?php if ( $settings['ere_show_bg_image'] == 'yes' ) {
		                 echo esc_url( $settings['cta_1_image']['url'] );
                 } ?> ) "
            <?php } ?>
            ></div>

			<?php if ( $settings['ere_enable_overlay'] == 'yes' ) { ?>
                <div class="rhea_overlay_cta_3"></div>
			<?php } ?>

            <div class="wrapper_content_cta_3_box">

                <div class="wrapper_content_cta_3_gutter">
                </div>
                <div class="wrapper_content_cta_3"
                     <?php if(!empty( $settings['rhea_cta_align'])){ ?>
                     style="text-align: <?php echo esc_attr( $settings['rhea_cta_align'] ); ?> "
                     <?php } ?>
                >
					<?php
					if ( ! empty( $settings['cta_top_title'] ) ) {
						?>
                        <h2 class="rhea_label_cta_3">
							<?php echo esc_html( $settings['cta_top_title'] ) ?>
                        </h2>
						<?php
					}
					if ( ! empty( $settings['cta_main_description'] ) ) {
						?>
                        <div class="rhea_description_cta_3">
                            <p>
	                        <?php echo wp_kses( $settings['cta_main_description'], $allowed_html ) ?>
                            </p>
                        </div>
						<?php
					}

					if ( ! empty( $settings['cta__btn_title'] ) && ! empty( $settings['cta_btn_url']['url'] ) ) {
						$target            = $settings['cta_btn_url']['is_external'] ? ' target="_blank" ' : ' ';
						$nofollow          = $settings['cta_btn_url']['nofollow'] ? ' rel="nofollow" ' : ' ';
						$custom_attributes = $settings['cta_btn_url']['custom_attributes']? $settings['cta_btn_url']['custom_attributes'] : ' ';
						?>
                        <div class="rh_cta__btns_elementor_three">
                            <a class="cta_three_elementor_button"
								<?php echo $target . ' ' . $nofollow . ' ' . $custom_attributes ?>
                               href="<?php echo esc_url( $settings['cta_btn_url']['url'] ); ?>">
								<?php echo esc_html( $settings['cta__btn_title'] ); ?>
                            </a>
                        </div>
						<?php
					}
					?>

                </div>
            </div>

        </section>

        <?php

	}

}