<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Properties_Widget_Two extends \Elementor\Widget_Base {
	private $is_rvr_enabled;

	public function __construct( array $data = [], ?array $args = null ) {
		parent::__construct( $data, $args );
		$this->is_rvr_enabled = rhea_is_rvr_enabled();
	}

	public function get_name() {
		return 'rhea-properties-widget-2';
	}

	public function get_title() {
		return esc_html__( 'RH: Properties V4 (Grid)', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-posts-grid rh-modern-widget';
	}

	public function get_keywords() {
		return [ 'RealHomes', 'Modern', 'Grid', 'Properties Grid' ];
	}

	public function get_categories() {
		return [ 'real-homes' ];
	}


	protected function register_controls() {

		$grid_size_array = wp_get_additional_image_sizes();

		$prop_grid_size_array = array();
		foreach ( $grid_size_array as $key => $value ) {
			$str_rpl_key = ucwords( str_replace( "-", " ", $key ) );

			$prop_grid_size_array[ $key ] = $str_rpl_key . ' - ' . $value['width'] . 'x' . $value['height'];
		}

		unset( $prop_grid_size_array['partners-logo'] );
		unset( $prop_grid_size_array['property-detail-slider-thumb'] );
		unset( $prop_grid_size_array['post-thumbnail'] );
		unset( $prop_grid_size_array['agent-image'] );
		unset( $prop_grid_size_array['gallery-two-column-image'] );
		unset( $prop_grid_size_array['post-featured-image'] );

		$default_prop_grid_size = 'property-thumb-image';

		$allowed_html = array(
			'a'      => array(
				'href'  => array(),
				'title' => array()
			),
			'br'     => array(),
			'em'     => array(),
			'strong' => array(),
		);

		$this->start_controls_section(
			'ere_properties_section',
			[
				'label' => esc_html__( 'Properties', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'ere_property_grid_thumb_sizes',
			[
				'label'   => esc_html__( 'Thumbnail Size', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => $default_prop_grid_size,
				'options' => $prop_grid_size_array
			]
		);

		$this->add_responsive_control(
			'ere_property_grid_layout',
			[
				'label'       => esc_html__( 'Layout', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Number of columns will be reduced automatically if parent container has insufficient width.', RHEA_TEXT_DOMAIN ) . '<br>' .
					esc_html__( '* To apply this, make sure "Style -> Property Width" field is empty.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '33.333%',
				'options'     => array(
					'25%'     => esc_html__( '4 Columns *Full Width Content', RHEA_TEXT_DOMAIN ),
					'33.333%' => esc_html__( '3 Columns', RHEA_TEXT_DOMAIN ),
					'50%'     => esc_html__( '2 Columns', RHEA_TEXT_DOMAIN ),
					'100%'    => esc_html__( '1 Column', RHEA_TEXT_DOMAIN ),
				),
				'selectors'   => [
					'{{WRAPPER}} .rhea_property_card_ele_stylish' => 'width: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of Properties', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 60,
				'step'    => 1,
				'default' => 6,
			]
		);


		// Select controls for Custom Taxonomies related to Property
		$property_taxonomies = get_object_taxonomies( 'property', 'objects' );
		if ( ! empty( $property_taxonomies ) && ! is_wp_error( $property_taxonomies ) ) {
			foreach ( $property_taxonomies as $single_tax ) {
				$options = [];
				$terms   = get_terms( $single_tax->name );

				if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
					foreach ( $terms as $term ) {
						$options[ $term->slug ] = $term->name;
					}
				}

				$this->add_control(
					$single_tax->name,
					[
						'label'       => $single_tax->label,
						'type'        => \Elementor\Controls_Manager::SELECT2,
						'multiple'    => true,
						'label_block' => true,
						'options'     => $options,
					]
				);
			}
		}


		// Sorting Controls
		$this->add_control(
			'orderby',
			[
				'label'   => esc_html__( 'Order By', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'date'       => esc_html__( 'Date', RHEA_TEXT_DOMAIN ),
					'price'      => esc_html__( 'Price', RHEA_TEXT_DOMAIN ),
					'title'      => esc_html__( 'Title', RHEA_TEXT_DOMAIN ),
					'menu_order' => esc_html__( 'Menu Order', RHEA_TEXT_DOMAIN ),
					'rand'       => esc_html__( 'Random', RHEA_TEXT_DOMAIN ),
				],
				'default' => 'date',
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => esc_html__( 'Order', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'asc'  => esc_html__( 'Ascending', RHEA_TEXT_DOMAIN ),
					'desc' => esc_html__( 'Descending', RHEA_TEXT_DOMAIN ),
				],
				'default' => 'desc',
			]
		);

		$this->add_control(
			'featured_properties_condition',
			[
				'label'   => esc_html__( 'Featured Properties', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'normal'             => esc_html__( 'Normal', RHEA_TEXT_DOMAIN ),
					'show_featured_only' => esc_html__( 'Show Featured Only', RHEA_TEXT_DOMAIN ),
					'hide_featured'      => esc_html__( 'Hide Featured', RHEA_TEXT_DOMAIN ),
				],
				'default' => 'normal',
			]
		);

		$this->add_control(
			'skip_sticky_properties',
			[
				'label'        => esc_html__( 'Skip Sticky Properties', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'rhea_show_pagination',
			[
				'label'        => esc_html__( 'Show Pagination', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'offset',
			[
				'label'   => esc_html__( 'Offset or Skip From Start', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => '0',
			]
		);


		$this->add_control(
			'ere_enable_thumbnail_animation',
			[
				'label'        => esc_html__( 'Enable Thumbnail Hover Animation', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'ere_show_property_media_count',
			[
				'label'        => esc_html__( 'Show Property Media Count', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'ere_show_featured_tag',
			[
				'label'        => esc_html__( 'Show Featured Tag', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'Show if property is set to featured', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'ere_show_label_tags',
			[
				'label'        => esc_html__( 'Show Property Label Tag', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'Show if property label text is set', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'ere_show_property_type',
			[
				'label'        => esc_html__( 'Show Property Type', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'ere_show_agents',
			[
				'label'        => esc_html__( 'Show Property Agents/Owners', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_verification_badge',
			[
				'label'        => esc_html__( 'Show Agent Verification Badge', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'ere_enable_fav_properties',
			[
				'label'        => esc_html__( 'Show Add To Favourite Button', RHEA_TEXT_DOMAIN ),
				'description'  => wp_kses( __( '<strong>Important:</strong> Make sure to select <strong>Show</strong> in Customizer <strong>Favorites</strong> settings. ', RHEA_TEXT_DOMAIN ), $allowed_html ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'ere_enable_compare_properties',
			[
				'label'        => esc_html__( 'Show Add To Compare Button  ', RHEA_TEXT_DOMAIN ),
				'description'  => wp_kses( __( '<strong>Important:</strong> Make sure <strong>Compare Properties</strong> is <strong>enabled</strong> in Customizer settings. ', RHEA_TEXT_DOMAIN ), $allowed_html ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_address',
			[
				'label'        => esc_html__( 'Show Address', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_excerpt',
			[
				'label'        => esc_html__( 'Show Excerpt', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'prop_excerpt_length',
			[
				'label'     => esc_html__( 'Excerpt Length (Words)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'min'       => 5,
				'max'       => 100,
				'default'   => 10,
				'condition' => [
					'show_excerpt' => 'yes',
				],
			]
		);

        $this->add_control(
            'rhea_rating_enable',
            [
                'label'        => esc_html__( 'Show Ratings?', RHEA_TEXT_DOMAIN ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
                'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

		$this->add_control(
			'show_date',
			[
				'label'        => esc_html__( 'Show Date', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'ere_choose_post_time_formats',
			[
				'label'     => esc_html__( 'Post Date Format', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => [
					'dashboard' => esc_html__( 'Default( Dashboard > Settings > General )', RHEA_TEXT_DOMAIN ),
					'default'   => esc_html__( 'Custom', RHEA_TEXT_DOMAIN ),
					'human'     => esc_html__( 'Human Readable', RHEA_TEXT_DOMAIN ),
				],
				'default'   => 'default',
				'condition' => [
					'show_date' => 'yes',
				],

			]
		);

		$this->add_control(
			'ere_choose_post_time_format_option',
			[
				'label'      => esc_html__( 'Post Date Format Options', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::SELECT,
				'options'    => [
					'F j, Y'           => esc_html__( 'November 6, 2010', RHEA_TEXT_DOMAIN ),
					'F j, Y g:i a'     => esc_html__( 'November 6, 2010 12:50 am', RHEA_TEXT_DOMAIN ),
					'F, Y'             => esc_html__( 'November, 2010', RHEA_TEXT_DOMAIN ),
					'g:i a'            => esc_html__( '12:50 am', RHEA_TEXT_DOMAIN ),
					'l, F jS, Y'       => esc_html__( 'Saturday, November 6th, 20', RHEA_TEXT_DOMAIN ),
					'M j, Y @ G:i'     => esc_html__( 'Nov 6, 2010 @ 0:50', RHEA_TEXT_DOMAIN ),
					'Y/m/d \a\t g:i A' => esc_html__( '2010/11/06 at 12:50 AM', RHEA_TEXT_DOMAIN ),
					'Y/m/d \a\t g:ia'  => esc_html__( '2010/11/06 at 12:50am', RHEA_TEXT_DOMAIN ),
					'Y/m/d g:i:s A'    => esc_html__( '2010/11/06 12:50:48 AM', RHEA_TEXT_DOMAIN ),
					'Y/m/d'            => esc_html__( ' 2010/11/06', RHEA_TEXT_DOMAIN ),
				],
				'default'    => 'F j, Y',
				'conditions' => [
					'relation' => 'and',
					'terms'    => [
						[
							'name'     => 'show_date',
							'operator' => '==',
							'value'    => 'yes'
						],
						[
							'name'     => 'ere_choose_post_time_formats',
							'operator' => '==',
							'value'    => 'default'
						],
					]
				],
			]
		);

		$this->add_control(
			'ere_show_property_status_with_price',
			[
				'label'        => esc_html__( 'Show Property Status with Price', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'rhea_show_old_price',
			[
				'label'        => esc_html__( 'Show Old Price', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'ere_property_typo_section',
			[
				'label' => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_heading_typography',
				'label'    => esc_html__( 'Heading', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} h3.rhea_heading_stylish a',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_address_typography',
				'label'    => esc_html__( 'Address', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_address_sty a',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_excerpt_typography',
				'label'    => esc_html__( 'Excerpt', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_prop_stylish_card__excerpt',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_added_typography',
				'label'    => esc_html__( 'Added', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_added_sty span',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_added_date_typography',
				'label'    => esc_html__( 'Date', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_added_sty',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_meta_labels_typography',
				'label'    => esc_html__( 'Meta Labels', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta .rhea_meta_titles',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_meta_figures_typography',
				'label'    => esc_html__( 'Figures', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta .figure',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_meta_postfix_typography',
				'label'    => esc_html__( 'Figure Postfix', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta .label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_status_typography',
				'label'    => esc_html__( 'Status', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_prop_card__priceLabel_sty span.rh_prop_card__status_sty',
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_price_typography',
				'label'    => esc_html__( 'Price', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_prop_card__priceLabel_sty .rh_prop_card__price_sty, {{WRAPPER}} .rh_prop_card__priceLabel_sty .rh_prop_card__price_sty .property-current-price',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_postfix_typography',
				'label'    => esc_html__( 'Price Postfix', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_prop_card__priceLabel_sty .rh_prop_card__price_sty span',
			]
		);

		if ( $this->is_rvr_enabled ) {

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'property_owner_label',
					'label'    => esc_html__( 'Owner Label', RHEA_TEXT_DOMAIN ),
					'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
					'selector' => '{{WRAPPER}} .rhea_agent_expand_wrapper .rhea_agent_list .rhea_owner_label',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'property_owner_title',
					'label'    => esc_html__( 'Owner Title', RHEA_TEXT_DOMAIN ),
					'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
					'selector' => '{{WRAPPER}} .rhea_agent_expand_wrapper .rhea_agent_list .rhea_owner_title',
				]
			);

		} else {

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'property_agent_typography',
					'label'    => esc_html__( 'Agent Title', RHEA_TEXT_DOMAIN ),
					'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
					'selector' => '{{WRAPPER}} .rhea_latest_properties_2 .rhea_bottom_tags_box .rhea_agent_list .rh_property_agent__title',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'property_agency_typography',
					'label'    => esc_html__( 'Agency Title', RHEA_TEXT_DOMAIN ),
					'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
					'selector' => '{{WRAPPER}} .rhea_latest_properties_2 .rhea_bottom_tags_box .rhea_agent_list .rh_property_agent__agency',
				]
			);

		}


		$this->end_controls_section();


		$this->start_controls_section(
			'ere_properties_labels',
			[
				'label' => esc_html__( 'Property Labels', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		if ( $this->is_rvr_enabled ) {
			$this->add_control(
				'ere_property_owner_label',
				[
					'label'   => esc_html__( 'Owner', RHEA_TEXT_DOMAIN ),
					'type'    => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Owner', RHEA_TEXT_DOMAIN ),
				]
			);
		}


		$this->add_control(
			'ere_property_added_label',
			[
				'label'   => esc_html__( 'Date Postfix', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Added:', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'ere_property_added_ago_label',
			[
				'label'     => esc_html__( 'Date Prefix', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'ago', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'ere_choose_post_time_formats' => 'human',
				],
			]
		);

		$this->add_control(
			'ere_property_featured_label',
			[
				'label'   => esc_html__( 'Featured', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Featured', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'ere_property_fav_label',
			[
				'label'   => esc_html__( 'Add To Favourite', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Add To Favourite', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'ere_property_fav_added_label',
			[
				'label'   => esc_html__( 'Added To Favourite', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Added To Favourite', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'ere_property_compare_label',
			[
				'label'   => esc_html__( 'Add To Compare', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Add To Compare', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'ere_property_compare_added_label',
			[
				'label'   => esc_html__( 'Added To Compare', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Added To Compare', RHEA_TEXT_DOMAIN ),
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'ere_properties_meta_settings',
			[
				'label' => esc_html__( 'Meta Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$get_meta = array(
			'bedrooms'    => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
			'bathrooms'   => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
			'area'        => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
			'garage'      => esc_html__( 'Garages/Parking', RHEA_TEXT_DOMAIN ),
			'year-built'  => esc_html__( 'Year Built', RHEA_TEXT_DOMAIN ),
			'lot-size'    => esc_html__( 'Lot Size', RHEA_TEXT_DOMAIN ),
			'property-id' => esc_html__( 'Property ID', RHEA_TEXT_DOMAIN ),
		);

		$meta_defaults = array(
			array(
				'rhea_property_meta_display' => 'bedrooms',
				'rhea_meta_repeater_label'   => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
			),
			array(
				'rhea_property_meta_display' => 'bathrooms',
				'rhea_meta_repeater_label'   => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
			),
			array(
				'rhea_property_meta_display' => 'area',
				'rhea_meta_repeater_label'   => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
			),
		);

		if ( $this->is_rvr_enabled ) {
			$get_meta = array(
				'bedrooms'   => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
				'bathrooms'  => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
				'area'       => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
				'garage'     => esc_html__( 'Garages/Parking', RHEA_TEXT_DOMAIN ),
				'year-built' => esc_html__( 'Year Built', RHEA_TEXT_DOMAIN ),
				'lot-size'   => esc_html__( 'Lot Size', RHEA_TEXT_DOMAIN ),
				'guests'     => esc_html__( 'Guests Capacity', RHEA_TEXT_DOMAIN ),
				'min-stay'   => esc_html__( 'Min Stay', RHEA_TEXT_DOMAIN ),
			);

			$meta_defaults = array(
				array(
					'rhea_property_meta_display' => 'bedrooms',
					'rhea_meta_repeater_label'   => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
				),
				array(
					'rhea_property_meta_display' => 'bathrooms',
					'rhea_meta_repeater_label'   => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
				),
				array(
					'rhea_property_meta_display' => 'guests',
					'rhea_meta_repeater_label'   => esc_html__( 'Guests', RHEA_TEXT_DOMAIN ),
				),
				array(
					'rhea_property_meta_display' => 'area',
					'rhea_meta_repeater_label'   => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
				),
			);

		}

		// Adding additional fields support
		$additional_fields = rhea_get_additional_fields();
		if ( ! empty( $additional_fields ) ) {
			foreach ( $additional_fields as $additional_field ) {
				$get_meta[ $additional_field['field_key'] ] = $additional_field['field_name'];
			}
		}

		$meta_repeater = new \Elementor\Repeater();


		$meta_repeater->add_control(
			'rhea_property_meta_display',
			[
				'label'   => esc_html__( 'Select Meta', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => $get_meta,
			]
		);

		$meta_repeater->add_control(
			'rhea_meta_repeater_label',
			[
				'label'   => esc_html__( 'Meta Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Add Label', RHEA_TEXT_DOMAIN ),
			]
		);


		$this->add_control(
			'rhea_add_meta_select',
			[
				'label'       => esc_html__( 'Add Meta', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $meta_repeater->get_controls(),
				'default'     => $meta_defaults,
				'title_field' => ' {{{ rhea_meta_repeater_label }}}',
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'ere_property_sizes',
			[
				'label' => esc_html__( 'Sizes & Spaces', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'ere_property_width',
			[
				'label'       => esc_html__( 'Property Width (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'This will over-ride the width of "Content -> Layout"', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_property_card_ele_stylish' => 'width: {{SIZE}}{{UNIT}};',

				],
			]
		);


		$this->add_responsive_control(
			'ere_property_content_padding',
			[
				'label'      => esc_html__( 'Content Area Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_detail_wrapper_2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'ere_property_title_margin_bottom',
			[
				'label'     => esc_html__( 'Title Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} h3.rhea_heading_stylish a' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'ere_property_address_margin_bottom',
			[
				'label'     => esc_html__( 'Address Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_address_sty' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);
		$this->add_responsive_control(
			'ere_property_excerpt_margin_bottom',
			[
				'label'     => esc_html__( 'Excerpt Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_prop_stylish_card__excerpt' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'ere_property_date_margin_bottom',
			[
				'label'     => esc_html__( 'Date Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_added_sty'                                     => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_rvr_ratings_wrapper_stylish .rhea_rvr_ratings' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'ere_prop_card_meta_wrap_margin',
			[
				'label' => esc_html__( 'Meta Bottom Margin (px)', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::SLIDER,

				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card_meta_wrap_stylish' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'ere_prop_card_meta_icon_size',
			[
				'label' => esc_html__( 'Meta Icon Size (px)', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::SLIDER,

				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'ere_prop_status_margin_bottom',
			[
				'label' => esc_html__( 'Meta Bottom Margin (px)', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::SLIDER,

				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card__priceLabel_sty span.rh_prop_card__status_sty' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'ere_prop_fav_icon_size',
			[
				'label' => esc_html__( 'Favourite/Compare Icons Size (px)', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::SLIDER,

				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_price_fav_box svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'ere_property_color',
			[
				'label' => esc_html__( 'Colors', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'rhea_property_background_color',
			[
				'label'     => esc_html__( 'Property Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_property_card_ele_stylish_inner' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_top_meta_bg',
			[
				'label'     => esc_html__( 'Top Meta Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_top_tags_box' => 'background: linear-gradient( {{VALUE}}, rgba(255,255,255,0))',
				],
			]
		);

		$this->add_control(
			'rhea_media_count_bg_color',
			[
				'label'     => esc_html__( 'Media Count Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_media' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_media_count_bg_hover_color',
			[
				'label'     => esc_html__( 'Media Count Background Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_media:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'rhea_media_count_color',
			[
				'label'     => esc_html__( 'Media Count Icon/Number Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_media'     => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_media svg' => 'fill: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'rhea_media_count_hover_color',
			[
				'label'     => esc_html__( 'Media Count Icon/Number Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_media:hover'     => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_media:hover svg' => 'fill: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'rhea_tag_feature_bg',
			[
				'label'     => esc_html__( 'Featured Tag Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_featured:before' => 'border-left-color: {{VALUE}};border-right-color: {{VALUE}};border-top-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_tag_feature_icon',
			[
				'label'     => esc_html__( 'Featured Tag Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_featured svg' => 'fill: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_tag_label_bg',
			[
				'label'     => esc_html__( 'Label Tag Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_hot:before' => 'border-left-color: {{VALUE}};border-right-color: {{VALUE}};border-top-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_tag_label_icon',
			[
				'label'     => esc_html__( 'Label Tag Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_hot svg' => 'fill: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_tag_tooltip',
			[
				'label'     => esc_html__( 'Tag Tooltip Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-tags .rhea_tags_tooltip_inner' => 'background: {{VALUE}};',
					'{{WRAPPER}} .rhea-tags .rhea_tags_tooltip:after' => 'border-top-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_tag_tooltip_text',
			[
				'label'     => esc_html__( 'Tag Tooltip Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-tags .rhea_tags_tooltip_inner' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'rhea_agent_area_bg',
			[
				'label'     => esc_html__( 'Agent Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_bottom_tags_box'   => 'background: linear-gradient(rgba(255,255,255,0), {{VALUE}} )',
					'{{WRAPPER}} .rhea_agent_expand_wrapper .rhea_agent_list_extra' => 'background: linear-gradient({{VALUE}}, {{VALUE}})',
				],
			]
		);

		$this->add_control(
			'rhea_agent_area_open_icon',
			[
				'label'     => esc_html__( 'Agent Down Arrow', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_agent_expand_wrapper .rhea_agents_expand_button' => 'color: {{VALUE}};',
				],
			]
		);

		if ( $this->is_rvr_enabled ) {
			$this->add_control(
				'rhea_owner_label_color',
				[
					'label'     => esc_html__( 'Owner Label', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .rhea_agent_expand_wrapper .rhea_agent_list .rhea_owner_label' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'rhea_owner_title_color',
				[
					'label'     => esc_html__( 'Owner Title', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .rhea_agent_expand_wrapper .rhea_agent_list .rhea_owner_title' => 'color: {{VALUE}};',
					],
				]
			);
		} else {
			$this->add_control(
				'rhea_agent_title_color',
				[
					'label'     => esc_html__( 'Agent Title', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .rhea_agent_expand_wrapper .rhea_agent_list .rh_property_agent__title' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'rhea_agent_title_color_hover',
				[
					'label'     => esc_html__( 'Agent Title Hover', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .rhea_agent_expand_wrapper .rhea_agent_list .rh_property_agent__title:hover' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'rhea_agency_title_color',
				[
					'label'     => esc_html__( 'Agency Title', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .rhea_agent_expand_wrapper .rhea_agent_list .rh_property_agent__agency' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'rhea_agency_title_color_hover',
				[
					'label'     => esc_html__( 'Agency Title Hover', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .rhea_agent_expand_wrapper .rhea_agent_list .rh_property_agent__agency:hover' => 'color: {{VALUE}};',
					],
				]
			);
		}


		$this->add_control(
			'rhea_property_type_bg_color',
			[
				'label'     => esc_html__( 'Property Type Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_prop_status_sty' => 'background-color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'rhea_property_type_color',
			[
				'label'     => esc_html__( 'Property Type', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_prop_status_sty' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'rhea_property_title_color',
			[
				'label'     => esc_html__( 'Property Title', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} h3.rhea_heading_stylish a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_property_title_color_hover',
			[
				'label'     => esc_html__( 'Property Title Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} h3.rhea_heading_stylish a:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_property_address_color',
			[
				'label'     => esc_html__( 'Address', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_address_sty a'                     => 'color: {{VALUE}};',
					'{{WRAPPER}} .rhea_address_sty .rhea_address_pin svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_address_color_hover',
			[
				'label'     => esc_html__( 'Address Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_address_sty:hover a'                     => 'color: {{VALUE}};',
					'{{WRAPPER}} .rhea_address_sty:hover .rhea_address_pin svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_excerpt_color',
			[
				'label'     => esc_html__( 'Excerpt', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_prop_stylish_card__excerpt' => 'color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'rhea_property_rating_stars',
            [
                'label'     => esc_html__( 'Rating Stars', RHEA_TEXT_DOMAIN ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .rhea_rvr_ratings_wrapper_stylish .rating-stars i'                                        => 'color: {{VALUE}};',
                    '{{WRAPPER}} .rhea_stars_avg_rating .rhea_rating_percentage .rhea_rating_line .rhea_rating_line_inner' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .rating-stars i.rated'                                                                    => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
			'rhea_property_added',
			[
				'label'     => esc_html__( 'Date Added', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_added_sty span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_added_date',
			[
				'label'     => esc_html__( 'Date', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_added_sty' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_meta_label',
			[
				'label'     => esc_html__( 'Meta Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta .rhea_meta_titles' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_meta_icon',
			[
				'label'     => esc_html__( 'Meta Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta svg'          => 'fill: {{VALUE}};',
					'{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta svg path'     => 'fill: {{VALUE}};',
					'{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta svg circle'   => 'fill: {{VALUE}};',
					'{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta i'            => 'color: {{VALUE}};',
					'{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta .rhea_guests' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_meta_figure',
			[
				'label'     => esc_html__( 'Meta Figure', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta .figure' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_meta_area_post_fix',
			[
				'label'     => esc_html__( 'Figure Postfix', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card_meta_wrap_stylish .rh_prop_card__meta .label' => 'color: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'rhea_property_status_color',
			[
				'label'     => esc_html__( 'Status', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card__priceLabel_sty span.rh_prop_card__status_sty' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_price_color',
			[
				'label'     => esc_html__( 'Price', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card__priceLabel_sty .rh_prop_card__price_sty' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_price_postfix_color',
			[
				'label'     => esc_html__( 'Price Postfix (ie. Monthly)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card__priceLabel_sty .rh_prop_card__price_sty span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_property_current_price_color',
			[
				'label'     => esc_html__( 'Price (Current Price)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card__priceLabel_sty .rh_prop_card__price_sty .property-current-price' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_property_old_price_color',
			[
				'label'     => esc_html__( 'Price (Old Price)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rh_prop_card__priceLabel_sty .rh_prop_card__price_sty .property-old-price' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_property_fav_icon_color',
			[
				'label'     => esc_html__( 'Favourite Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .add-to-favorite .rh_svg' => 'fill: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_property_fav_icon_hover_color',
			[
				'label'     => esc_html__( 'Favourite Icon Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .add-to-favorite:hover .rh_svg' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .highlight__red .rh_svg'        => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_icon_tooltips',
			[
				'label'     => esc_html__( 'Favourite Tooltip Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .add-to-favorite:before'      => 'border-top-color: {{VALUE}};',
					'{{WRAPPER}} .favorite-placeholder:before' => 'border-top-color: {{VALUE}};',
					'{{WRAPPER}} .add-to-favorite:after'       => 'background: {{VALUE}};',
					'{{WRAPPER}} .favorite-placeholder:after'  => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_property_icon_tooltips_text',
			[
				'label'     => esc_html__( 'Favourite Tooltip Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .add-to-favorite:after'      => 'color: {{VALUE}};',
					'{{WRAPPER}} .favorite-placeholder:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_property_compare_icon_color',
			[
				'label'     => esc_html__( 'Compare Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_add_to_compare svg' => 'fill: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_property_compare_icon_color:hover',
			[
				'label'     => esc_html__( 'Compare Icon Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_add_to_compare:hover svg' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .highlight svg path'            => 'fill: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'rhea_property_compare_icon_tooltips',
			[
				'label'     => esc_html__( 'Compare Tooltip Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .add-to-compare-span [data-tooltip]:not([flow]):hover::before' => 'border-top-color: {{VALUE}};',
					'{{WRAPPER}} .add-to-compare-span [data-tooltip]:not([flow]):hover::after'  => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_property_compare_icon_tooltips_text',
			[
				'label'     => esc_html__( 'Compare Tooltip Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .add-to-compare-span [data-tooltip]:not([flow]):hover::after' => 'color: {{VALUE}};',
				],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'ere_properties_box_shadow',
			[
				'label' => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'label'    => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea_property_card_ele_stylish_inner',
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'rhea_properties_status_colors',
			[
				'label' => esc_html__( 'Status Over Image', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'rhea_property_status_padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [],
				'selectors'  => [
					'{{WRAPPER}} .rhea_prop_status_sty' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'property_status_border_radius',
			[
				'label' => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::SLIDER,

				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_prop_status_sty' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'rhea_property_status_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_prop_status_sty',
			]
		);

		$rhea_status_terms = get_terms( array(
			'taxonomy' => 'property-status',
		) );
		$get_status_terms  = array();
		foreach ( $rhea_status_terms as $rhea_term ) {
			$get_status_terms[ $rhea_term->slug ] = $rhea_term->name;
		}

		$status_repeater = new \Elementor\Repeater();
		$status_repeater->add_control(
			'rhea_property_status_select_section',
			[
				'label'   => esc_html__( 'Select Status', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => $get_status_terms,
			]
		);
		$status_repeater->add_control(
			'rhea_get_terms_bg',
			[
				'label'   => esc_html__( 'Status Background Color', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '',

			]
		);
		$status_repeater->add_control(
			'rhea_get_terms_colors',
			[
				'label'   => esc_html__( 'Status Text Color', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::COLOR,
				'default' => '',

			]
		);
		$this->add_control(
			'rhea_property_status_select',
			[
				'label'       => esc_html__( 'Change Status Colors', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $status_repeater->get_controls(),
				'title_field' => ' {{{ rhea_property_status_select_section }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_pagination',
			[
				'label' => esc_html__( 'Pagination', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]

		);

		$this->add_responsive_control(
			'rhea_pagination_contianer_margin',
			[
				'label'      => esc_html__( 'Pagination Container Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea_latest_properties_ajax .pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_space_between_links',
			[
				'label'     => esc_html__( 'Space Between (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_ajax .pagination a' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: {{SIZE}}{{UNIT}};',

				],
			]
		);
		$this->add_responsive_control(
			'rhea_pagination_link_padding',
			[
				'label'      => esc_html__( 'Pagination Links Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea_latest_properties_ajax .pagination a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_pagination_border_radius',
			[
				'label'     => esc_html__( 'Border Radius(px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_ajax .pagination a' => 'border-radius: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_pagination_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_latest_properties_ajax .pagination a',
			]
		);

		$this->add_control(
			'rhea_pagination_bg_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_ajax .pagination a' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_pagination_bg_hover_color',
			[
				'label'     => esc_html__( 'Background Hover/Current Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_ajax .pagination a:hover'   => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea_latest_properties_ajax .pagination a.current' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_pagination_text_color',
			[
				'label'     => esc_html__( 'Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_ajax .pagination a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_pagination_text_hover_color',
			[
				'label'     => esc_html__( 'Text Hover/Current Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_ajax .pagination a:hover'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_latest_properties_ajax .pagination a.current' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pagination_box_shadow',
				'label'    => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea_latest_properties_ajax .pagination a',
			]
		);


		$this->end_controls_section();


	}

	protected function render() {
		global $settings;
		global $properties_query;
		global $widget_id;

		$widget_id = $this->get_id();
		$settings  = $this->get_settings_for_display();
		$meta_query = array();

		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} else if ( get_query_var( 'page' ) ) { // if is static front page
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}

		if ( $settings['offset'] ) {
			$offset = $settings['offset'] + ( $paged - 1 ) * $settings['posts_per_page'];
		} else {
			$offset = '';
		}

		// Basic Query
		$properties_args = array(
			'post_type'      => 'property',
			'posts_per_page' => $settings['posts_per_page'],
			'order'          => $settings['order'],
			'offset'         => $offset,
			'post_status'    => 'publish',
			'paged'          => $paged,
		);

		// Sticky property filtering
		if ( $settings['skip_sticky_properties'] !== 'yes' ) {
			$meta_query[] = [
				'key'     => 'REAL_HOMES_sticky',
				'compare' => 'EXISTS',
			];
		}

		// Featured properties condition
		if ( ! empty( $settings['featured_properties_condition'] ) ) {
			$condition = $settings['featured_properties_condition'];

			if ( 'show_featured_only' === $condition ) {
				$meta_query[] = [
					'key'     => 'REAL_HOMES_featured',
					'value'   => 1,
					'compare' => '=',
					'type'    => 'NUMERIC',
				];
			} else if ( 'hide_featured' === $condition ) {
				$meta_query[] = [
					'key'     => 'REAL_HOMES_featured',
					'value'   => 1,
					'compare' => '!=',
					'type'    => 'NUMERIC',
				];
			}
		}

		// Add meta_query if not empty
		if ( ! empty( $meta_query ) ) {
			$properties_args['meta_query'] = $meta_query;
		}

        // Sorting
		if ( 'price' === $settings['orderby'] ) {
			$properties_args['orderby']  = 'meta_value_num';
			$properties_args['meta_key'] = 'REAL_HOMES_property_price';
		} else {
			// for date, title, menu_order and rand
			$properties_args['orderby'] = $settings['orderby'];
		}

		// Filter based on custom taxonomies
		$property_taxonomies = get_object_taxonomies( 'property', 'objects' );
		if ( ! empty( $property_taxonomies ) && ! is_wp_error( $property_taxonomies ) ) {
			foreach ( $property_taxonomies as $single_tax ) {
				$setting_key = $single_tax->name;
				if ( ! empty( $settings[ $setting_key ] ) ) {
					$properties_args['tax_query'][] = [
						'taxonomy' => $setting_key,
						'field'    => 'slug',
						'terms'    => $settings[ $setting_key ],
					];
				}
			}

			if ( isset( $properties_args['tax_query'] ) && count( $properties_args['tax_query'] ) > 1 ) {
				$properties_args['tax_query']['relation'] = 'AND';
			}
		}

		$properties_query = new WP_Query( apply_filters( 'rhea_modern_properties_widget', $properties_args ) );
		?>
        <section id="rh-<?php echo $this->get_id(); ?>" class="rh_elementor_widget rhea_ele_property_ajax_target rhea_latest_properties_ajax rhea_has_tooltip">


			<?php
			if ( $properties_query->have_posts() ) {
				?>
                <div class="home-properties-section-inner-target">
                    <div class="rh_properties_pagination_append rhea_latest_properties_2">
						<?php
						while ( $properties_query->have_posts() ) {
							$properties_query->the_post();


							?>
                            <div class="rhea_property_card_ele_stylish">
                                <div class="rhea_property_card_ele_stylish_inner">
                                    <div class="rhea_thumbnail_wrapper">
                                        <div class="rhea_top_tags_box">
											<?php
											if ( $settings['ere_show_property_media_count'] == 'yes' ) {
												rhea_get_template_part( 'assets/partials/stylish/media-count' );
											}
											rhea_get_template_part( 'assets/partials/stylish/tags' );
											?>
                                        </div>

                                        <div class="rhea_bottom_tags_box">
		                                    <?php
		                                    if ( 'yes' == $settings['ere_show_agents'] ) {
			                                    if ( $this->is_rvr_enabled ) {
				                                    rhea_get_template_part( 'assets/partials/stylish/rvr-owner' );

			                                    } else {
				                                    rhea_get_template_part( 'assets/partials/stylish/agent-in-listing' );
			                                    }
		                                    }

		                                    // Getting current property type terms
		                                    $property_types = ere_get_property_types( get_the_ID() );

		                                    if (
			                                    '&nbsp;' != $property_types
			                                    && ! empty( $settings['ere_show_property_type'] )
			                                    && 'yes' == $settings['ere_show_property_type']
		                                    ) {
			                                    $prop_type_styles = ! empty( $this_status_bg ) ? 'background: ' . esc_attr( $this_status_bg ) . ' ;' : '';
			                                    $prop_type_styles .= ! empty( $this_status_colors ) ? 'color: ' . esc_attr( $this_status_colors ) . ' ;' : '';
			                                    ?>
                                                <div class="rhea_soi_prop_status_sty">
                                                    <span class="rhea_prop_status_sty" style="<?php echo esc_attr( $prop_type_styles ); ?>">
                                                        <?php
                                                        echo wp_kses( $property_types, [ 'small' => [] ] );
                                                        ?>
                                                    </span>
                                                </div>
			                                    <?php
		                                    }
		                                    ?>
                                        </div>

										<?php
										rhea_get_template_part( 'assets/partials/stylish/thumbnail' );

										?>
                                    </div>
                                    <div class="rhea_detail_wrapper rh_detail_wrapper_2">

										<?php
										rhea_get_template_part( 'assets/partials/stylish/heading' );

										rhea_get_template_part( 'assets/partials/stylish/address' );
										rhea_get_template_part( 'assets/partials/stylish/excerpt' );


										if ( 'yes' == $settings['rhea_rating_enable'] ) {
											?>
                                            <div class="rhea_rvr_ratings_wrapper_stylish rvr_rating_left">
												<?php
												inspiry_rating_average( [ 'rating_string' => false ] );
												?>
                                            </div>
											<?php
										}

										if ( 'yes' == $settings['show_date'] ) {
											rhea_get_template_part( 'assets/partials/stylish/added' );
										}

										rhea_get_template_part( 'assets/partials/stylish/grid-card-meta' );
										?>
                                        <div class="rhea_price_fav_box">

                                            <div class="rhea_price_box">
												<?php
												rhea_get_template_part( 'assets/partials/stylish/price' );
												?>
                                            </div>

                                            <div class="rhea_fav_icon_box rhea_parent_fav_button">
		                                        <?php
		                                        if ( 'yes' === $settings['ere_enable_fav_properties'] && function_exists( 'inspiry_favorite_button' ) ) {
			                                        inspiry_favorite_button( get_the_ID(), $settings['ere_property_fav_label'], $settings['ere_property_fav_added_label'] );
		                                        }
		                                        rhea_get_template_part( 'assets/partials/stylish/compare' );
		                                        ?>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
							<?php
						}
						?>
                    </div>
					<?php
					if ( 'yes' == $settings['rhea_show_pagination'] ) {
						?>
                        <div class="rhea_svg_loader">
							<?php include RHEA_ASSETS_DIR . '/icons/loading-bars.svg'; ?>
                        </div>
						<?php
						RHEA_ajax_pagination( $properties_query->max_num_pages );
					}
					?>
                </div>
				<?php
				wp_reset_postdata();
			}
			?>
        </section>
		<?php
	}
}

?>
