<?php
/**
 * This file contains the Ultra properties widget top bar.
 *
 * @version 2.3.0
 */

global $settings, $widget_id, $properties_query, $paged, $column_classes;

if ( 'yes' === $settings['enable_top_bar'] ) {
	$page_id = get_the_ID();
	?>
    <div class="rhea-ultra-properties-top-bar">
        <div class="rhea-ultra-properties-top-bar-stats-wrapper">
			<?php
			if ( 'yes' === $settings['enable_statistics'] ) {
				$found_properties = $properties_query->found_posts;
				$per_page         = $properties_query->query_vars['posts_per_page'];
				$state_first      = ( $per_page * $paged ) - $per_page + 1;
				$state_last       = min( $found_properties, $per_page * $paged );
				?>
                <p class="rhea-ultra-properties-stats" data-page="<?php echo intval( $paged ); ?>" data-max="<?php echo intval( $properties_query->max_num_pages ); ?>" data-total-properties="<?php echo intval( $found_properties ); ?>" data-page-id="<?php echo intval( $page_id ); ?>">
					<?php
					if ( $found_properties > 0 && ( $found_properties >= $per_page || -1 !== $per_page ) ) {
						?>
                        <span><?php echo intval( $state_first ); ?></span>
						<?php esc_html_e( 'to', RHEA_TEXT_DOMAIN ); ?>
                        <span><?php echo intval( $state_last ); ?></span>
						<?php esc_html_e( 'out of ', RHEA_TEXT_DOMAIN ); ?>
                        <span><?php echo intval( $found_properties ); ?></span>
						<?php esc_html_e( 'properties', RHEA_TEXT_DOMAIN ); ?><?php
					}
					?>
                </p>
				<?php
			}
			?>
        </div><!-- .rhea-ultra-properties-top-bar-stats-wrapper -->
        <div class="rhea-ultra-properties-top-bar-sorting-and-view">
			<?php
			if ( 'yes' === $settings['enable_frontend_sorting'] ) {

				if ( function_exists( 'realhomes_generate_sort_control_option' ) ) {
					realhomes_generate_sort_control_option( array(
						'container_classes' => 'rhea-ultra-properties-top-bar-sort-controls',
						'select_classes'    => 'rh-ultra-select-dropdown show-tick',
						'selected_item'     => ! empty( $_GET['sortby'] ) ? sanitize_text_field( wp_unslash( $_GET['sortby'] ) ) : ''
					) );
				}
			}

			if ( 'yes' === $settings['enable_layout_toggle_buttons'] ) {
				?>
                <div class="rhea-ultra-properties-top-bar-view-type rh-ultra-view-type">
					<?php
					$layout   = '';
					$page_url = '';

					if ( is_tax() ) {
						$term_link = get_term_link( get_queried_object()->term_id );
						if ( ! is_wp_error( $term_link ) ) {
							$page_url = $term_link;
						}
					} else {
						$page_url = get_permalink( $page_id );
					}

					$separator = ( null == parse_url( $page_url, PHP_URL_QUERY ) ) ? '?' : '&';

					if ( isset( $_GET['rhea-properties-view'] ) && in_array( $_GET['rhea-properties-view'], array( 'grid', 'list' ) ) ) {
						$layout = sanitize_text_field( $_GET['rhea-properties-view'] );
					} else {
						if ( $settings['layout'] && in_array( $settings['layout'], array( 'grid', 'list' ) ) ) {
							$layout = $settings['layout'];
						}
					}
					?>
                    <a class="grid <?php echo ( 'grid' === $layout ) ? 'active' : ''; ?>" href="<?php echo esc_url( $page_url . $separator . 'rhea-properties-view=grid' ); ?>">
						<?php rhea_safe_include_svg( 'icons/icon-sort-grid.svg' ); ?>
                    </a>
                    <a class="list <?php echo ( 'list' === $layout ) ? 'active' : ''; ?>" href="<?php echo esc_url( $page_url . $separator . 'rhea-properties-view=list' ); ?>">
						<?php rhea_safe_include_svg( 'icons/icon-sort-list.svg' ); ?>
                    </a>
                </div><!-- .rhea-ultra-properties-view-type -->
				<?php
			}
			?>
        </div><!-- .rhea-ultra-properties-top-bar-sorting-and-view -->
    </div><!-- .rhea-ultra-properties-top-bar -->
	<?php
}