<?php
/**
 * Action buttons widget for single property template
 *
 * @since 2.3.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Ultra_Single_Property_Action_Buttons extends \Elementor\Widget_Base {
	public function get_name() {
		return 'rhea-ultra-single-property-action-buttons';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Action Buttons', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-call-to-action rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__( 'Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_favourite_button',
			[
				'label'        => esc_html__( 'Show Favourite Button', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'ere_enable_compare_properties',
			[
				'label'        => esc_html__( 'Show Compare Button', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'show_print_button',
			[
				'label'        => esc_html__( 'Show Print Button', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'show_share_button',
			[
				'label'        => esc_html__( 'Show Share Button', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'show_report_button',
			[
				'label'        => esc_html__( 'Show Report Button', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'labels_section',
			[
				'label' => esc_html__( 'Labels', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'favourites_label_add',
			[
				'label'   => esc_html__( 'Add to Favourites Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Add to favourites', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'favourites_label_added',
			[
				'label'   => esc_html__( 'Added to Favourites Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Added to favourites', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'compare_label',
			[
				'label'   => esc_html__( 'Add to Compare Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Add to compare', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'compare_label_added',
			[
				'label'   => esc_html__( 'Added to Compare Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Added to compare', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'print_label',
			[
				'label'   => esc_html__( 'Print Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Print', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'share_label',
			[
				'label'   => esc_html__( 'Share Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Share', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'report_label',
			[
				'label'   => esc_html__( 'Report Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Report this Property', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'basic_settings',
			[
				'label' => esc_html__( 'Size & Spacing', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'action_buttons_wrapper_padding',
			[
				'label'      => esc_html__( 'Buttons Wrapper Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-action-buttons-wrap .rh-ultra-action-buttons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'action_buttons_wrapper_border_radius',
			[
				'label'     => esc_html__( 'Wrapper Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-action-buttons-wrap .rh-ultra-action-buttons' => 'border-radius: {{SIZE}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'action_buttons_size',
			[
				'label'     => esc_html__( 'Buttons Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-action-buttons-wrap .rh-ultra-action-buttons a svg'    => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-action-buttons-wrap .rh-ultra-action-buttons span svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-action-buttons-wrap .rh-ultra-action-buttons a i'      => 'font-size: {{SIZE}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'action_buttons_margin',
			[
				'label'      => esc_html__( 'Content Area Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-action-buttons-wrap .rh-ultra-action-buttons > *' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'colors_section',
			[
				'label' => esc_html__( 'Colors', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'action_buttons_wrap_bg',
			[
				'label'     => esc_html__( 'Action Buttons Wrapper Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-action-buttons-wrap .rh-ultra-action-buttons' => 'background-color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'action_buttons_color',
			[
				'label'     => esc_html__( 'Action Fonts Buttons Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-action-buttons-wrap .rh-ultra-action-buttons i' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'action_buttons_color_hover',
			[
				'label'     => esc_html__( 'Action Fonts Hover Buttons Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-action-buttons-wrap .rh-ultra-action-buttons a:hover i' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'action-icon-stroke-dark',
			[
				'label'     => esc_html__( 'Icon Stroke Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-action-buttons .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-icon-stroke-dark-hover',
			[
				'label'     => esc_html__( 'Icon Stroke Dark Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap .highlight__red .rh-ultra-stroke-dark'    => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a:hover .rh-ultra-stroke-dark'            => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span .highlight .rh-ultra-stroke-dark'       => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a:hover .rh-ultra-stroke-dark'          => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-action-buttons .print:hover .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-action-buttons .share:hover .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-icon-stroke-light',
			[
				'label'     => esc_html__( 'Icon Stroke Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-action-buttons .rh-ultra-stroke-light' => 'stroke: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'action-icon-stroke-light-hover',
			[
				'label'     => esc_html__( 'Icon Stroke Light Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap .highlight__red .rh-ultra-stroke-light' => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a:hover .rh-ultra-stroke-light'         => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span .highlight .rh-ultra-stroke-light'    => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a:hover .rh-ultra-stroke-light'       => 'stroke: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'action-icon-fill-dark',
			[
				'label'     => esc_html__( 'Icon Fill Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-action-buttons svg'            => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-action-buttons .rh-ultra-dark' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-action-buttons .st0'           => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-icon-fill-dark-hover',
			[
				'label'     => esc_html__( 'Icon Fill Dark Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-action-buttons a:hover svg'              => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-action-buttons a:hover .rh-ultra-dark'   => 'fill: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap .highlight__red .rh-ultra-dark' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a:hover .rh-ultra-dark'         => 'fill: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span .highlight .rh-ultra-dark'    => 'fill: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a:hover .rh-ultra-dark'       => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-icon-fill-light',
			[
				'label'     => esc_html__( 'Icon Fill Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-action-buttons .rh-ultra-light' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-action-buttons .st1'            => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-icon-fill-light-hover',
			[
				'label'     => esc_html__( 'Icon Fill Light Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap .highlight__red .rh-ultra-light' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a:hover .rh-ultra-light'         => 'fill: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span .highlight .rh-ultra-light'    => 'fill: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a:hover .rh-ultra-light'       => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-action-buttons a:hover .rh-ultra-light'   => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-added-buttons',
			[
				'label'     => esc_html__( 'Action Button Added State', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'fav-fill-dark-added',
			[
				'label'     => esc_html__( 'Favourite Icon Added Fill Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap span.highlight__red .rh-ultra-dark' => 'fill: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'fav-fill-light-added',
			[
				'label'     => esc_html__( 'Favourite Icon Added Fill Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap span.highlight__red .rh-ultra-light' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'fav-stroke-dark-added',
			[
				'label'     => esc_html__( 'Favourite Icon Added Stroke Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap span.highlight__red .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'fav-stroke-light-added',
			[
				'label'     => esc_html__( 'Favourite Icon Added Stroke Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap span.highlight__red .rh-ultra-stroke-light' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'compare-fill-dark-added',
			[
				'label'     => esc_html__( 'Compare Icon Added Fill Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .add-to-compare-span span.highlight .rh-ultra-dark' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'compare-fill-light-added',
			[
				'label'     => esc_html__( 'Compare Icon Added Fill Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .add-to-compare-span span.highlight .rh-ultra-light' => 'fill: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'compare-stroke-dark-added',
			[
				'label'     => esc_html__( 'Compare Icon Added Stroke Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .add-to-compare-span span.highlight .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'compare-stroke-light-added',
			[
				'label'     => esc_html__( 'Compare Icon Added Stroke Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .add-to-compare-span span.highlight .rh-ultra-stroke-light' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		global $settings;
		global $post_id;
		$settings = $this->get_settings_for_display();
		$post_id  = get_the_ID();

		// Sample Post id for Elementor editor only
		if ( rhea_is_preview_mode() ) {
			$post_id = rhea_get_sample_property_id();
		}
		?>
        <div class="rhea-action-buttons-wrap">
            <div class="rh-ultra-action-buttons">
				<?php
				// Favorite button for single property
				rhea_render_single_property_favourite_button( $post_id, $settings, '/common/images/icons/ultra-favourite.svg', 'ultra' );
				// Compare button for single property
				rhea_render_single_property_compare_button( $post_id, $settings );
				// Print button for single property
				if ( ! empty( $settings['show_print_button'] ) && 'yes' === $settings['show_print_button'] ) {
					$print_tooltip = ! empty( $settings['print_label'] ) ? $settings['print_label'] : esc_attr__( 'Print', RHEA_TEXT_DOMAIN );
					?>
                    <a href="javascript:window.print()" class="print rh-ui-tooltip" title="<?php echo esc_attr( $print_tooltip ); ?>">
						<?php
						if ( ! RealHomes_Render_Icons::realhomes_custom_icons( 'realhomes_print_button_icon' ) ) {
							rhea_safe_include_svg( '/icons/print-icon.svg' );
						}
						?>
                    </a>
					<?php
				}
				// Share button for single property
				if ( ! empty( $settings['show_share_button'] ) && 'yes' === $settings['show_share_button'] ) {
					$share_tooltip = ! empty( $settings['share_label'] ) ? $settings['share_label'] : esc_attr__( 'Share', RHEA_TEXT_DOMAIN );
					?>
                    <div class="rh-ultra-share-wrapper">
                        <a href="#" class="rh-ultra-share share rh-ui-tooltip" title="<?php echo esc_attr( $share_tooltip ); ?>">
							<?php
							if ( ! RealHomes_Render_Icons::realhomes_custom_icons( 'realhomes_share_button_icon' ) ) {
								rhea_safe_include_svg( 'icons/share-icon.svg' );
							}
							?>
                        </a>
                        <div class="share-this" data-check-mobile="<?php echo wp_is_mobile() ? esc_attr( 'mobile' ) : ''; ?>" data-property-name="<?php the_title(); ?>" data-property-permalink="<?php the_permalink(); ?>"></div>
                    </div>
					<?php
				}
				// Report button for single property
				if ( ! empty( $settings['show_report_button'] ) && 'yes' === $settings['show_report_button'] && function_exists( 'realhomes_report_property_modal' ) ) {

					$report_tooltip = ! empty( $settings['report_label'] ) ? $settings['report_label'] : esc_attr__( 'Report this property', RHEA_TEXT_DOMAIN );

					// Inserting report property modal html with the wp_footer action
					add_action( 'wp_footer', 'realhomes_report_property_modal' );
					?>
                    <a class="report-this-property rh-ui-tooltip" href="#report-property-modal-<?php echo esc_attr( $post_id ); ?>" data-post-id="<?php echo esc_attr( $post_id ); ?>" title="<?php echo esc_html( $report_tooltip ); ?>">
						<?php
						if ( ! RealHomes_Render_Icons::realhomes_custom_icons( 'realhomes_report_button_icon' ) ) {
							?>
                            <i class="fas fa-flag"></i>
							<?php
						}
						?>
                    </a>
					<?php
				}
				?>
            </div>
        </div>
		<?php
	}

}