<?php
/**
 * Single Property Attachments Widget V2.
 *
 * @since 2.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Single_Property_Attachments_V2 extends \Elementor\Widget_Base {

	use RHEA_Single_Property_V2_Title_Section_Trait;

	// Static properties for reusable data.
	private static $property_id;

	public function __construct( $data = [], $args = null ) {
		parent::__construct( $data, $args );

		if ( is_null( self::$property_id ) ) {
			self::$property_id = $this->initialize_property_id();
		}
	}

	public function get_name() {
		return 'rh-single-property-attachments-v2';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Attachments V2', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-document-file rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {

		$this->title_section_content_tab_controls( esc_html__( 'Property Attachments', RHEA_TEXT_DOMAIN ) );

		$this->title_section_style_tab_controls();

		$this->start_controls_section(
			'attachments_section',
			[
				'label' => esc_html__( 'Attachments', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'attachment_number_of_columns',
			[
				'label'     => esc_html__( 'Number of Columns', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 4,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 li' => '--attachments: {{SIZE}};',
				],
			]
		);

		$this->add_responsive_control(
			'attachment_gap',
			[
				'label'     => esc_html__( 'Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2-list' => '--attachments-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'attachment_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'attachment_padding',
			[
				'label'     => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'attachment_bg',
			[
				'label'     => esc_html__( 'Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 a' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'attachment_bg_hover',
			[
				'label'     => esc_html__( 'Background Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 a:hover' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'attachment_border_color',
			[
				'label'     => esc_html__( 'Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 a' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'attachment_border_hover_color',
			[
				'label'     => esc_html__( 'Border Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 a:hover' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'label'    => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-single-property-attachments-v2 a',
			]
		);

		$this->add_control(
			'icon_heading',
			[
				'label'     => esc_html__( 'Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'attachment_icon_size',
			[
				'label'     => esc_html__( 'Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'attachment_icon_bottom_margin',
			[
				'label'     => esc_html__( 'Bottom Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 i' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'attachment_icon',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'attachment_icon_hover',
			[
				'label'     => esc_html__( 'Color Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 a:hover i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'title_heading',
			[
				'label'     => esc_html__( 'Title', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'attachment_title_bottom_margin',
			[
				'label'     => esc_html__( 'Bottom Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'attachment_title',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'attachment_title_hover',
			[
				'label'     => esc_html__( 'Color Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 a:hover .rh-single-property-attachments-v2-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'attachment_title_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-single-property-attachments-v2-title',
			]
		);

		$this->add_control(
			'size_heading',
			[
				'label'     => esc_html__( 'Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'attachment_size',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2-size' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'attachment_size_hover',
			[
				'label'     => esc_html__( 'Color Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2 a:hover .rh-single-property-attachments-v2-size' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'attachment_size_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-single-property-attachments-v2-size',
			]
		);

		$this->add_control(
			'download_icon_heading',
			[
				'label'     => esc_html__( 'Download Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'attachment_download_icon_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-attachments-v2-icon' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

		// Check if login required to vew property detail.
		if ( inspiry_prop_detail_login() ) {
			return;
		}

		$settings    = $this->get_settings_for_display();
		$widget_id   = $this->get_id();
		$attachments = inspiry_get_property_attachments( self::$property_id );

		if ( ! empty( $attachments ) ) {
			?>
            <div id="rh-single-property-attachments-v2-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-attachments-v2">
				<?php
				if ( ! empty( $settings['section_title'] ) ) {
					?>
                    <h4 class="rh-single-property-section-heading rh-single-property-section-heading-common"><?php echo esc_html( $settings['section_title'] ); ?></h4>
					<?php
				}
				?>
                <div class="rh-single-property-attachments-v2-inner">
                    <ul class="rh-single-property-attachments-v2-list">
						<?php
						foreach ( $attachments as $attachment_id ) {
							$file_path = wp_get_attachment_url( $attachment_id );

							if ( $file_path ) {
								$file_type = wp_check_filetype( $file_path );
								$extension = $file_type['ext'];
								?>
                                <li class="<?php echo esc_attr( $extension ) ?>">
                                    <a href="<?php echo esc_attr( $file_path ); ?>" target="_blank">
										<?php echo get_icon_for_extension( $extension ); ?>
                                        <span class="rh-single-property-attachments-v2-info">
                                            <span class="rh-single-property-attachments-v2-title"><?php echo get_the_title( $attachment_id ) ?></span>
                                            <span class="rh-single-property-attachments-v2-size"><?php echo inspiry_filesize_formatted( get_attached_file( $attachment_id ) ) ?></span>
                                        </span>
                                        <span class="rh-single-property-attachments-v2-icon"><?php inspiry_safe_include_svg( 'download.svg', '/assets/ultra/icons/' ); ?></span>
                                    </a>
                                </li>
								<?php
							}
						}
						?>
                    </ul>
                </div>
            </div>
			<?php
		} else {
			rhea_print_no_result_for_editor();
		}
	}

	private function initialize_property_id() {
		if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
			return rhea_get_sample_property_id();
		}

		return get_the_ID();
	}
}