<?php
/**
 * Single Property Images Gallery Widget V4.
 *
 * @since 2.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Single_Property_Gallery_V4 extends \Elementor\Widget_Base {

	public function __construct( array $data = [], ?array $args = null ) {
		parent::__construct( $data, $args );

		wp_register_script( 'rh-single-property-gallery-v4', RHEA_PLUGIN_URL . 'elementor/js/rh-single-property-gallery-v4.js', [ 'elementor-frontend' ], RHEA_VERSION, true );
	}

	public function get_name() {
		return 'rh-single-property-gallery-v4';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Gallery V4 (Carousel)', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-slider-full-screen rh-ultra-widget';
	}

	public function get_keywords() {
		return [ 'RealHomes', 'Single Property', 'Single Property Gallery', 'Single Property Carousel', 'Single Property Slider' ];
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	public function get_script_depends() {
		return [ 'rh-single-property-gallery-v4' ];
	}

	public function get_style_depends() {
		return [ 'swiper' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'settings',
			[
				'label' => esc_html__( 'Carousel', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'infinite',
			[
				'label'              => esc_html__( 'Infinite Loop', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'no',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'              => esc_html__( 'Autoplay', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'no',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'pause_on_hover',
			[
				'label'              => esc_html__( 'Pause on Hover', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'condition'          => [
					'autoplay' => 'yes',
				],
				'render_type'        => 'none',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'pause_on_interaction',
			[
				'label'              => esc_html__( 'Pause on Interaction', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'condition'          => [
					'autoplay' => 'yes',
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label'              => esc_html__( 'Autoplay Speed', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 4000,
				'condition'          => [
					'autoplay' => 'yes',
				],
				'render_type'        => 'none',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'speed',
			[
				'label'              => esc_html__( 'Animation Speed', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 700,
				'render_type'        => 'none',
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'pagination_section',
			[
				'label' => esc_html__( 'Carousel Navigations', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'pagination_bg_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled span' => '--swiper-pagination-bullet-inactive-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'pagination_active_bullet_bg_color',
			[
				'label'     => esc_html__( 'Active Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled span.swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .swiper-pagination-styled .select-active-bullet'                => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pagination_container_section',
			[
				'label' => esc_html__( 'Container Options', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'pagination_container_margin',
			[
				'label'     => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_container_padding',
			[
				'label'     => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'pagination_items_options_section',
			[
				'label' => esc_html__( 'Items Options', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'pagination_items_gap',
			[
				'label'     => esc_html__( 'Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled .swiper-pagination-inner' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_items_width',
			[
				'label'     => esc_html__( 'Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swiper-pagination-styled .select-active-bullet'     => 'width: calc({{SIZE}}{{UNIT}} + 6px);',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_items_height',
			[
				'label'     => esc_html__( 'Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swiper-pagination-styled .select-active-bullet'     => 'height: calc({{SIZE}}{{UNIT}} + 6px);',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_items_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled .swiper-pagination-bullet,
					 {{WRAPPER}} .swiper-pagination-styled .select-active-bullet' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

		// Check if login required to vew property detail.
		if ( inspiry_prop_detail_login() ) {
			return;
		}

		$property_id = get_the_ID();
		// Sample property id for editor side,
		if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
			$property_id = rhea_get_sample_property_id();
		}

		$settings            = $this->get_settings_for_display();
		$widget_id           = $this->get_id();
		$property_gallery    = '';
		$property_image_size = 'post-featured-image';
		$container_classes[] = 'rh-single-property-gallery-v4';
		$property_images     = rwmb_meta( 'REAL_HOMES_property_images', 'type=plupload_image&size=' . $property_image_size, $property_id );
		$is_rtl              = is_rtl() ? 'dir="rtl"' : '';
		?>
        <section id="rh-single-property-gallery-v4-<?php echo esc_attr( $widget_id ); ?>" class="<?php echo join( " ", $container_classes ); ?>" data-count="<?php echo esc_attr( count( $property_images ) ) ?>">
			<?php
			if ( ! empty( $property_images ) && 1 < count( $property_images ) ) {
				$lightbox_caption  = '';
				$title_in_lightbox = ( 'true' == get_option( 'inspiry_display_title_in_lightbox', 'false' ) );

				foreach ( $property_images as $id => $property_image_meta ) {
					if ( $title_in_lightbox ) {
						$lightbox_caption = 'data-caption="' . $property_image_meta['title'] . '"';
					}

					$property_gallery .= '<div class="swiper-slide"><figure class="rh-single-property-gallery-v4-image-wrapper">';
					$property_gallery .= sprintf( '<a href="%s" data-fancybox="gallery" %s>%s</a>', esc_url( $property_image_meta['full_url'] ), esc_attr( $lightbox_caption ), wp_get_attachment_image( $id, 'full' ) );
					$property_gallery .= '</figure></div>';
				}
				?>
                <div id="rh-single-property-gallery-v4-slider-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-gallery-v4-slider swiper swiper-container" <?php echo esc_attr( $is_rtl ); ?>>
                    <div class="swiper-wrapper">
						<?php echo $property_gallery; ?>
                    </div>
                </div>
                <div id="swiper-pagination-<?php echo esc_attr( $widget_id ); ?>" class="swiper-pagination swiper-pagination-styled">
                    <div class="swiper-pagination-inner"></div>
                </div>
				<?php
			} else {
				if ( has_post_thumbnail( $property_id ) ) {
					$property_thumbnail = get_the_post_thumbnail_url( $property_id, $property_image_size );
				} else {
					$property_thumbnail = inspiry_get_raw_placeholder_url( $property_image_size );
				}
				?>
                <div class="rh-property-featured-image" style="background-image: url('<?php echo esc_url( $property_thumbnail ); ?>'); "></div>
				<?php
			}
			?>
        </section>
		<?php
	}
}