<?php
/**
 * Single Property Map Widget V2.
 *
 * @since 2.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Single_Property_Map_V2 extends \Elementor\Widget_Base {

	use RHEA_Single_Property_V2_Title_Section_Trait;

	// Static properties for reusable data.
	private static $property_id;

	public function __construct( $data = [], $args = null ) {
		parent::__construct( $data, $args );

		// Initialize static properties if not already set.
		if ( is_null( self::$property_id ) ) {
			self::$property_id = $this->initialize_property_id();
		}
	}

	public function get_name() {
		return 'rh-single-property-map-v2';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Map V2', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-google-maps rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {

		$this->title_section_content_tab_controls( esc_html__( 'Property on Map', RHEA_TEXT_DOMAIN ) );

		$this->title_section_style_tab_controls();

		$this->start_controls_section(
			'map_styles_section',
			[
				'label' => esc_html__( 'Map', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'map_zoom',
			[
				'label'     => esc_html__( 'Zoom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
				],
				'frontend_available' => true,
			]
		);

		$this->add_responsive_control(
			'map_height',
			[
				'label'     => esc_html__( 'Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} #property_map' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'map_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} #property_map' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} #property_map',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

		// Check if login required to vew property detail.
		if ( inspiry_prop_detail_login() ) {
			return;
		}

		$settings     = $this->get_settings_for_display();
		$widget_id    = $this->get_id();
		$editor_class = '';

		// Sample Post id for Elementor editor only
		if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
			$editor_class = ' rhea-map-temp-background';
		}

		$property_location = get_post_meta( self::$property_id, 'REAL_HOMES_property_location', true );
		$property_address  = get_post_meta( self::$property_id, 'REAL_HOMES_property_address', true );
		$hide_property_map = get_post_meta( self::$property_id, 'REAL_HOMES_property_map', true );

		if ( ! empty( $property_address ) && ! empty( $property_location ) && ( '1' !== $hide_property_map ) ) {
			?>
            <div id="rh-single-property-map-v2-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-map-v2 <?php realhomes_printable_section( 'map' ); ?>">
				<?php
				if ( ! empty( $settings['section_title'] ) ) {
					?>
                    <h4 class="rh-single-property-section-heading rh-single-property-section-heading-common"><?php echo esc_html( $settings['section_title'] ); ?></h4>
					<?php
				}
				?>
                <div class="rh-single-property-map-v2-inner <?php echo esc_attr( $editor_class ); ?>">
                    <div id="property_map">
						<?php
						if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
							rhea_print_no_result( esc_html__( 'Map will be displayed on frontend only', RHEA_TEXT_DOMAIN ) );
						}
						?>
                    </div>
                </div>
            </div>
			<?php
		} else {
			rhea_print_no_result_for_editor();
		}
	}

	private function initialize_property_id() {
		if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
			return rhea_get_sample_property_id();
		}

		return get_the_ID();
	}
}