<?php
/**
 * Single Property Virtual Tour Widget V2.
 *
 * @since 2.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Single_Property_Virtual_Tour_V2 extends \Elementor\Widget_Base {

	use RHEA_Single_Property_V2_Title_Section_Trait;

	// Static properties for reusable data.
	private static $property_id;

	public function __construct( $data = [], $args = null ) {
		parent::__construct( $data, $args );

		if ( is_null( self::$property_id ) ) {
			self::$property_id = $this->initialize_property_id();
		}
	}

	public function get_name() {
		return 'rh-single-property-virtual-tour-v2';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Virtual Tour V2', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-video-camera rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {

		$this->title_section_content_tab_controls( esc_html__( 'Property Tour', RHEA_TEXT_DOMAIN ) );

		$this->title_section_style_tab_controls();

		$this->start_controls_section(
			'virtual_tour_section',
			[
				'label' => esc_html__( 'Virtual Tour', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'container_border_padding',
			[
				'label'     => esc_html__( 'Container Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-virtual-tour-v2-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'container_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-virtual-tour-v2-inner, {{WRAPPER}} .rh-single-property-virtual-tour-v2 iframe' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'selector' => '{{WRAPPER}} .rh-single-property-virtual-tour-v2-inner',
			]
		);

		$this->add_responsive_control(
			'height',
			[
				'label'     => esc_html__( 'Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} iframe' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

		// Check if login required to vew property detail.
		if ( inspiry_prop_detail_login() ) {
			return;
		}

		if ( 'true' !== get_option( 'inspiry_display_virtual_tour' ) ) {
			return;
		}

		$settings     = $this->get_settings_for_display();
		$widget_id    = $this->get_id();
		$virtual_tour = trim( get_post_meta( self::$property_id, 'REAL_HOMES_360_virtual_tour', true ) );

		if ( ! empty( $virtual_tour ) ) {
			?>
            <div id="rh-single-property-virtual-tour-v2-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-virtual-tour-v2">
				<?php
				if ( ! empty( $settings['section_title'] ) ) {
					?>
                    <h4 class="rh-single-property-section-heading rh-single-property-section-heading-common"><?php echo esc_html( $settings['section_title'] ); ?></h4>
					<?php
				}
				?>
                <div class="rh-single-property-virtual-tour-v2-inner">
					<?php
					if ( ( has_shortcode( $virtual_tour, 'ipanorama' ) || has_shortcode( $virtual_tour, 'ipano' ) ) && class_exists( 'iPanorama_Activator' ) ) {
						echo do_shortcode( $virtual_tour );
					} else {
						echo wp_kses( $virtual_tour, inspiry_embed_code_allowed_html() );
					}
					?>
                </div>
            </div>
			<?php
		} else {
			rhea_print_no_result_for_editor();
		}
	}

	private function initialize_property_id() {
		if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
			return rhea_get_sample_property_id();
		}

		return get_the_ID();
	}
}