<?php
/**
 * Property Meta Elementor widget for single property
 *
 * @since 2.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Property_Meta_V3 extends \Elementor\Widget_Base {

	public function get_name() {
		return 'rhea-property-meta-v3';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Meta V3', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-bullet-list rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'property-meta-settings',
			[
				'label' => esc_html__( 'Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'select-meta-type',
			[
				'label'   => esc_html__( 'Select Meta', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'price'      => esc_html__( 'Price', RHEA_TEXT_DOMAIN ),
					'id'         => esc_html__( 'Property ID', RHEA_TEXT_DOMAIN ),
					'address'    => esc_html__( 'Address', RHEA_TEXT_DOMAIN ),
					'featured'   => esc_html__( 'Featured', RHEA_TEXT_DOMAIN ),
					'types'      => esc_html__( 'Types', RHEA_TEXT_DOMAIN ),
					'status'     => esc_html__( 'Status', RHEA_TEXT_DOMAIN ),
					'date'       => esc_html__( 'Date', RHEA_TEXT_DOMAIN ),
					'year-built' => esc_html__( 'Year Built', RHEA_TEXT_DOMAIN ),
				],
				'default' => 'price',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property-price-settings',
			[
				'label'     => esc_html__( 'Price', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);


		$this->add_control(
			'display-price-prefix',
			[
				'label'     => esc_html__( 'Display Price Prefix', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => [
					'none'         => esc_html__( 'None', RHEA_TEXT_DOMAIN ),
					'inline-block' => esc_html__( 'Inline', RHEA_TEXT_DOMAIN ),
					'block'        => esc_html__( 'Block', RHEA_TEXT_DOMAIN ),
				],
				'selectors' => [
					'{{WRAPPER}} .ere-price-prefix' => 'display: {{VALUE}};',
				],
				'default'   => 'none',
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_control(
			'display-old-price',
			[
				'label'     => esc_html__( 'Display Old Price', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => [
					'none'         => esc_html__( 'None', RHEA_TEXT_DOMAIN ),
					'inline-block' => esc_html__( 'Inline', RHEA_TEXT_DOMAIN ),
					'block'        => esc_html__( 'Block', RHEA_TEXT_DOMAIN ),
				],
				'selectors' => [
					'{{WRAPPER}} .property-old-price' => 'display: {{VALUE}};',
				],
				'default'   => 'none',
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_control(
			'display-price-separator',
			[
				'label'     => esc_html__( 'Display Price Separator', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => [
					'none'         => esc_html__( 'None', RHEA_TEXT_DOMAIN ),
					'inline-block' => esc_html__( 'Inline', RHEA_TEXT_DOMAIN ),
				],
				'selectors' => [
					'{{WRAPPER}} .ere-price-slash' => 'display: {{VALUE}};',
				],
				'default'   => 'none',
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);


		$this->add_control(
			'display-price-postfix',
			[
				'label'     => esc_html__( 'Display Price Postfix', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => [
					'none'         => esc_html__( 'None', RHEA_TEXT_DOMAIN ),
					'inline-block' => esc_html__( 'Inline', RHEA_TEXT_DOMAIN ),
					'block'        => esc_html__( 'Block', RHEA_TEXT_DOMAIN ),
				],
				'selectors' => [
					'{{WRAPPER}} .ere-price-postfix' => 'display: {{VALUE}};',
				],
				'default'   => 'none',
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'price-prefix-typography',
				'label'     => esc_html__( 'Prefix Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .ere-price-prefix',
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'price-typography',
				'label'     => esc_html__( 'Price Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .ere-price-display',
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'old-price-typography',
				'label'     => esc_html__( 'Old Price Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .property-old-price',
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'price-separator-typography',
				'label'     => esc_html__( 'Price Separator Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .ere-price-slash',
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'price-postfix-typography',
				'label'     => esc_html__( 'Postfix Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .ere-price-postfix',
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_control(
			'price-prefix-color',
			[
				'label'     => esc_html__( 'Prefix Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ere-price-prefix' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_control(
			'price-color',
			[
				'label'     => esc_html__( 'Price Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ere-price-display' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_control(
			'old-price-color',
			[
				'label'     => esc_html__( 'Old Price Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .property-old-price' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_control(
			'price-separator-color',
			[
				'label'     => esc_html__( 'Separator Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ere-price-slash' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->add_control(
			'price-postfix-color',
			[
				'label'     => esc_html__( 'Postfix Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ere-price-postfix' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'price'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property-id-settings',
			[
				'label'     => esc_html__( 'Property ID', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'select-meta-type' => 'id'
				]
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'property-id-typography',
				'label'     => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rhea-property-id .property-id',
				'condition' => [
					'select-meta-type' => 'id'
				]
			]
		);

		$this->add_control(
			'property-id-color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-property-id .property-id' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'id'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property-address-settings',
			[
				'label'     => esc_html__( 'Address', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'select-meta-type' => 'address'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'property-address-typography',
				'label'     => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rh-property-address',
				'condition' => [
					'select-meta-type' => 'address'
				]
			]
		);

		$this->add_control(
			'property-address-color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-property-address' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'address'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property-featured-settings',
			[
				'label'     => esc_html__( 'Featured Tag', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'select-meta-type' => 'featured'
				]
			]
		);

		$this->add_control(
			'property_featured_label',
			[
				'label'     => esc_html__( 'Featured Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Featured', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'select-meta-type' => 'featured'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'property-featured-typography',
				'label'     => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rhea-meta-featured',
				'condition' => [
					'select-meta-type' => 'featured'
				]
			]
		);

		$this->add_control(
			'property-featured-text-color',
			[
				'label'     => esc_html__( 'Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-meta-featured' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'featured'
				]
			]
		);

		$this->add_control(
			'property-featured-bg-color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-meta-featured' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'featured'
				]
			]
		);

		$this->add_control(
			'property-featured-border-color',
			[
				'label'     => esc_html__( 'Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-meta-featured' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'featured'
				]
			]
		);

		$this->add_responsive_control(
			'property-featured-padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-meta-featured' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'property-featured-radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-meta-featured' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property-types-settings',
			[
				'label'     => esc_html__( 'Types Tags', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'select-meta-type' => 'types'
				]
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'property-types-typography',
				'label'     => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rhea-ultra-property-types small, {{WRAPPER}} .rhea-ultra-property-types small a',
				'condition' => [
					'select-meta-type' => 'types'
				]
			]
		);

		$this->add_control(
			'property-types-text-color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-property-types small'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-ultra-property-types small a' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'types'
				]
			]
		);

		$this->add_control(
			'property-types-text-hover-color',
			[
				'label'     => esc_html__( 'Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-property-types small a:hover' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'types'
				]
			]
		);

		$this->add_responsive_control(
			'property-types-margin',
			[
				'label'      => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-ultra-property-types small' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property-status-settings',
			[
				'label'     => esc_html__( 'Status Tags', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'select-meta-type' => 'status'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'property-status-typography',
				'label'     => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rhea-ultra-status-box a',
				'condition' => [
					'select-meta-type' => 'status'
				]
			]
		);

		$this->add_responsive_control(
			'property-status-padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-ultra-status-box a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'property-status-border-radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-ultra-status-box a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'property-status-text-color',
			[
				'label'     => esc_html__( 'Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-status-box a' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'status'
				]
			]
		);

		$this->add_control(
			'property-status-text-hover-color',
			[
				'label'     => esc_html__( 'Text Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-status-box a:hover' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'status'
				]
			]
		);

		$this->add_control(
			'property-status-bg-color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-status-box a' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'status'
				]
			]
		);

		$this->add_control(
			'property-status-bg-hover-color',
			[
				'label'     => esc_html__( 'Background Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-status-box a:hover' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'status'
				]
			]
		);

		$this->add_control(
			'property-status-border-color',
			[
				'label'     => esc_html__( 'Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-status-box a' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'status'
				]
			]
		);

		$this->add_control(
			'property-status-border-hover-color',
			[
				'label'     => esc_html__( 'Border Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-status-box a:hover' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'status'
				]
			]
		);


		$this->add_responsive_control(
			'status-column-gap',
			[
				'label'     => esc_html__( 'Column Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-status-box' => 'column-gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select-meta-type' => 'status'
				]
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'property-date-settings',
			[
				'label'     => esc_html__( 'Date Added', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'select-meta-type' => 'date'
				]
			]
		);

		$this->add_control(
			'added_date_label',
			[
				'label'     => esc_html__( 'Date Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Added: ', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'select-meta-type' => 'date'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'property-date-typography',
				'label'     => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rhea-date-added',
				'condition' => [
					'select-meta-type' => 'date'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'property-date-added-typography',
				'label'     => esc_html__( 'Added Label Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rhea-date-added .added-title',
				'condition' => [
					'select-meta-type' => 'date'
				]
			]
		);

		$this->add_control(
			'property-date-color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-date-added' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'date'
				]
			]
		);

		$this->add_control(
			'property-date-added-color',
			[
				'label'     => esc_html__( 'Added Label Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-date-added .added-title' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'date'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property-year-built-settings',
			[
				'label'     => esc_html__( 'Year Built', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'select-meta-type' => 'year-built'
				]
			]
		);

		$this->add_control(
			'year-built-label',
			[
				'label'     => esc_html__( 'Year Built', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Year Built: ', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'select-meta-type' => 'year-built'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'property-year-built-typography',
				'label'     => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rhea-property-year-built',
				'condition' => [
					'select-meta-type' => 'year-built'
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'property-year-built-label-typography',
				'label'     => esc_html__( 'Year Built Label Typography', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rhea-property-year-built .year-built-title',
				'condition' => [
					'select-meta-type' => 'year-built'
				]
			]
		);

		$this->add_control(
			'property-year-built-color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-property-year-built' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'year-built'
				]
			]
		);

		$this->add_control(
			'property-year-built-label-color',
			[
				'label'     => esc_html__( 'Year Built Label Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-property-year-built .year-built-title' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select-meta-type' => 'year-built'
				]
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings  = $this->get_settings_for_display();
		$widget_id = $this->get_id();

		if ( rhea_is_preview_mode() ) {
			$property_id = rhea_get_sample_property_id();
		} else {
			$property_id = get_the_ID();
		}

		switch ( $settings['select-meta-type'] ) {
			case 'price' :
				?>
                <div class="rhea-property-price-meta"><?php echo ere_get_property_price( $property_id, true, true ); ?></div>
				<?php
				break;
			case 'id' :
				$rh_property_id = get_post_meta( $property_id, 'REAL_HOMES_property_id', true );
				if ( ! empty( $property_id ) ) {
					?>
                    <div class="rhea-property-id">
                        <span class="property-id"><?php echo esc_html( $rh_property_id ); ?></span>
                    </div>
					<?php
				}
				break;
			case 'address' :
				$property_address = get_post_meta( $property_id, 'REAL_HOMES_property_address', true );

				if ( ! empty( $property_address ) ) {
					?>
                    <address class="rh-property-address">
						<?php echo esc_html( $property_address ); ?>
                    </address>
					<?php
				}
				break;
			case 'featured' :
				$is_featured = get_post_meta( $property_id, 'REAL_HOMES_featured', true );
				if ( $is_featured == '1' ) {
					?>
                    <span class="rhea-meta-featured">
                        <?php
                        if ( ! empty( $settings['property_featured_label'] ) ) {
	                        echo esc_html( $settings['property_featured_label'] );
                        } else {
	                        esc_html_e( 'Featured', RHEA_TEXT_DOMAIN );
                        }
                        ?>
                    </span>
					<?php
				}
				break;
			case 'types' :
				$type_terms = get_the_terms( $property_id, "property-type" );
				if ( ! empty( $type_terms ) ) {
					if ( function_exists( 'ere_get_property_types' ) && ! empty( ere_get_property_types( $property_id ) ) ) {
						?>
                        <span class="rhea-ultra-property-types">
                            <?php echo ere_get_property_types( $property_id, true ); ?>
                        </span>
						<?php
					}
				}
				break;
			case 'status' :
				$status_terms = get_the_terms( $property_id, 'property-status' );
				if ( ! empty( $status_terms ) ) {
					?>
                    <div class="rhea-ultra-status-box">
						<?php
						foreach ( $status_terms as $term ) {
							?>
                            <a href="<?php echo get_term_link( $term->term_id ) ?>" class="rhea-ultra-status"><?php echo esc_html( $term->name ) ?></a>
							<?php
						}
						?>
                    </div>
					<?php
				}
				break;
			case 'date' :
				?>
                <div class="rhea-date-added">
					<?php
					if ( ! empty( $settings['added_date_label'] ) ) {
						?>
                        <span class="added-title"><?php echo esc_html( $settings['added_date_label'] ); ?></span>
						<?php
					}
					echo get_the_date( '', $property_id );
					?>
                </div>
				<?php
				break;
			case 'year-built' :
				$property_year_built = get_post_meta( $property_id, 'REAL_HOMES_property_year_built', true );
				if ( ! empty( $property_year_built ) ) {
					?>
                    <div class="rhea-property-year-built">
						<?php
						if ( ! empty( $settings['year-built-label'] ) ) {
							?>
                            <span class="year-built-title"><?php echo esc_html( $settings['year-built-label'] ); ?></span>
							<?php
						}
						echo esc_html( $property_year_built );
						?>
                    </div>
					<?php
				}
				break;
			default :
				esc_html_e( 'No Meta Selected', RHEA_TEXT_DOMAIN );
		}

	}

}
