<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Properties_Grid_WPML_Translate {

	public function __construct() {
		add_filter( 'wpml_elementor_widgets_to_translate', [
			$this,
			'inspiry_properties_grid_to_translate'
		] );

	}
	public function inspiry_properties_grid_to_translate( $widgets ) {

		$widgets['rhea-properties-widget'] = [
			'conditions' => [ 'widgetType' => 'rhea-properties-widget' ],
			'fields'     => [
				[
					'field'       => 'ere_property_featured_label',
					'type'        => esc_html__( 'Properties Grid: Featured', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'ere_property_view_prop_label',
					'type'        => esc_html__( 'Properties Grid: View Property', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'ere_property_fav_label',
					'type'        => esc_html__( 'Properties Grid: Add To Favourite', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'ere_property_fav_added_label',
					'type'        => esc_html__( 'Properties Grid: Added To Favourite', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'ere_property_compare_label',
					'type'        => esc_html__( 'Properties Grid: Add To Compare', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'ere_property_compare_added_label',
					'type'        => esc_html__( 'Properties Grid: Added To Compare', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],

			],
			'integration-class' => 'RHEA_Properties_One_Repeater_WPML_Translate',
		];

		return $widgets;

	}
}

class RHEA_Properties_One_Repeater_WPML_Translate extends WPML_Elementor_Module_With_Items {
	public function get_items_field() {
		return 'rhea_add_meta_select';
	}

	public function get_fields() {
		return array( 'rhea_meta_repeater_label' );
	}

	protected function get_title( $field ) {
		switch ( $field ) {
			case 'rhea_meta_repeater_label':
				return esc_html__( 'Properties Grid: Meta Label', RHEA_TEXT_DOMAIN );
			default:
				return '';
		}
	}

	protected function get_editor_type( $field ) {
		switch ( $field ) {
			case 'rhea_meta_repeater_label':
				return 'LINE';
			default:
				return '';
		}
	}
}

new RHEA_Properties_Grid_WPML_Translate();