<?php
/***
 * This class is responsible for the RHEA widgets tiles color scheme according to the design variation.
 *
 * @since 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'RHEA_Elementor_Color_Scheme' ) ) {

	class RHEA_Elementor_Color_Scheme {

		/***
		 * RHEA_Elementor_Color_Scheme's singleton instance.
		 *
		 * @var RHEA_Elementor_Color_Scheme
		 */
		protected static $_instance;

		/***
		 * Class constructor function to help run elementor hooks.
		 */
		public function __construct() {
			add_action( 'elementor/editor/wp_head', array( $this, 'widgets_tiles_classes' ), 100 );
			add_action( 'elementor/editor/wp_head', array( $this, 'widgets_tiles_color_scheme' ), 100 );
		}

		/***
		 * Class instance creation function to avoid multiple instances.
		 *
		 * @return RHEA_Elementor_Color_Scheme
		 */
		public static function instance(): RHEA_Elementor_Color_Scheme {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		/***
		 * Add widgets tiles wrappers classes according to their design variation category.
		 *
		 * @return void
		 */
		public function widgets_tiles_classes() {
			echo "<script>
				// Function to apply tiles changes
				function modifyElementorTiles() {
				    document.querySelectorAll('.elementor-element-wrapper').forEach((element) => {
				        // Check if it contains a child with 'rh-ultra-widget' and add 'rh-ultra-widget-wrapper'
				        if (element.querySelector('.rh-ultra-widget')) {
				            element.classList.add('rh-ultra-widget-wrapper');
				        }
				        
				        // Check if it contains a child with 'rh-modern-widget' and add 'rh-modern-widget-wrapper'
				        if (element.querySelector('.rh-modern-widget')) {
				            element.classList.add('rh-modern-widget-wrapper');
				        }
				        
				        // Check if it contains a child with 'rh-classic-widget' and add 'rh-classic-widget-wrapper'
				        if (element.querySelector('.rh-classic-widget')) {
				            element.classList.add('rh-classic-widget-wrapper');
				        }
				    });
				}
				
				// Set up a MutationObserver to detect when the elements are added to the DOM
				const observer = new MutationObserver(function (mutations) {
				    mutations.forEach(function (mutation) {
				        if (mutation.type === 'childList') {
				            modifyElementorTiles(); // Call tiles modifying function when changes are detected
				        }
				    });
				});
				
				// Start observing the document for changes (or observe a specific container)
				observer.observe(document.body, {
				    childList: true, // Watch for direct children being added or removed
				    subtree: true    // Watch for all descendants being added or removed
				});
				
				</script>";
		}

		/***
		 * Color scheme styles of the widgets tiles according to their design variation category.
		 *
		 * @return void
		 */
		public function widgets_tiles_color_scheme() {
			echo '<style>
				  /*** General Styles ***/
				  .elementor-element-wrapper .elementor-element {padding:2px}
				  .elementor-panel .elementor-element .title-wrapper {margin-top:10px;padding-bottom:10px}
				  .elementor-element-wrapper .elementor-element .title {line-height:16px;}
				 /*** Only for RHEA Widgets ***/
				 .rh-ultra-widget-wrapper .icon,
				 .rh-ultra-widget-wrapper .title {color: #1db2ff;}
				 .rh-modern-widget-wrapper .icon,
				 .rh-modern-widget-wrapper .title {color: #18998e;}
				 .rh-classic-widget-wrapper .icon,
				 .rh-classic-widget-wrapper .title {color: #e3712c;}
			  </style>';
		}
	}
}

/***
 * Returns the main instance of RHEA_Elementor_Color_Scheme to prevent the need to use globals.
 *
 * @return RHEA_Elementor_Color_Scheme
 */
function RHEA_Elementor_Color_Scheme(): RHEA_Elementor_Color_Scheme {
	return RHEA_Elementor_Color_Scheme::instance();
}

// Get RHEA_Elementor_Color_Scheme Running.
RHEA_Elementor_Color_Scheme();