<?php
if ( ! function_exists( 'custom_fields_to_email_body' ) ) {
	/**
	 * Add Inquiry Form custom fields values into Email body
	 */
	function custom_fields_to_email_body( $email_body ) {
		$rhea_custom_label = array();
		if ( isset( $_POST['rhea_custom_label'] ) ) {
			$rhea_custom_label = ( $_POST['rhea_custom_label'] );
		}
		$rhea_custom_field = array();
		if ( isset( $_POST['rhea_custom_field'] ) ) {
			$rhea_custom_field = ( $_POST['rhea_custom_field'] );
		}
		$additional_details = array_combine( $rhea_custom_label, $rhea_custom_field );
		?>

		<?php


		if ( $additional_details && ! empty( $additional_details ) ) {
			$custom = array();
			foreach ( $additional_details as $key => $value ) {
				if ( is_array( $value ) && ( $value ) ) {
					$string   = implode( ", ", $value );
					$custom[] = array(
						'name'  => $key,
						'value' => $string,
					);
				} else if ( ! empty( $value ) ) {
					$custom[] = array(
						'name'  => $key,
						'value' => $value,
					);
				}
			}

			return array_merge( $email_body, $custom );
		}

		return $email_body;
	}
}

if ( ! function_exists( 'rhea_send_contact_message' ) ) {
	/**
	 * Handler for Contact form on contact page template
	 */
	function rhea_send_contact_message() {


		if ( isset( $_POST['email'] ) ):

			/*
			 * Verify Nonce
			 */
			if ( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( $_POST['nonce'], 'rhea_inquiry_form' ) ) {
				echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Security verification failed, please refresh the page and try again.', RHEA_TEXT_DOMAIN )
				) );
				die;
			}

			/* Verify Google reCAPTCHA */
			if ( function_exists( 'ere_verify_google_recaptcha' ) ) {
				ere_verify_google_recaptcha();
			}

			/*
			 * Sanitize and Validate Target email address that will be configured from theme options
			 */

			$to_email = sanitize_email( $_POST['target-email'] );


			$to_email = is_email( $to_email );

			if ( ! $to_email ) {
				echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Target Email address is not properly configured!', RHEA_TEXT_DOMAIN )
				) );
				die;
			}

			/*
			 * Sanitize and Validate contact form input data
			 */
			$contact_prefix = '';
			if ( isset( $_POST['prefix'] ) ) {
				$contact_prefix = sanitize_text_field( $_POST['prefix'] );
			}
			if ( isset( $_POST['name'] ) ) {
				$from_name = sanitize_text_field( $contact_prefix ) . ' ' . sanitize_text_field( $_POST['name'] );
			}
			if ( isset( $_POST['number'] ) ) {
				$phone_number = sanitize_text_field( $_POST['number'] );
			}
			if ( isset( $_POST['home_phone'] ) ) {
				$home_number = sanitize_text_field( $_POST['home_phone'] );
			}
			if ( isset( $_POST['work_phone'] ) ) {
				$office_number = sanitize_text_field( $_POST['work_phone'] );
			}
			if ( isset( $_POST['country'] ) ) {
				$country = sanitize_text_field( $_POST['country'] );
			}
			if ( isset( $_POST['address'] ) ) {
				$address = sanitize_text_field( $_POST['address'] );
			}
			if ( isset( $_POST['city'] ) ) {
				$city = sanitize_text_field( $_POST['city'] );
			}
			if ( isset( $_POST['state'] ) ) {
				$state = sanitize_text_field( $_POST['state'] );
			}
			if ( isset( $_POST['zipcode'] ) ) {
				$zip = sanitize_text_field( $_POST['zipcode'] );
			}
			if ( isset( $_POST['source'] ) ) {
				$source = sanitize_text_field( $_POST['source'] );
			}
			if ( isset( $_POST['agent'] ) ) {
				$agent = sanitize_text_field( $_POST['agent'] );
			}
			if ( isset( $_POST['message'] ) ) {
				$message = stripslashes( $_POST['message'] );
			}


			$from_email = sanitize_email( $_POST['email'] );
			$from_email = is_email( $from_email );
			if ( ! $from_email ) {
				echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Provided Email address is invalid!', RHEA_TEXT_DOMAIN )
				) );
				die;
			}

			/*
			 * Email Subject
			 */
			$email_subject = esc_html__( 'New message sent by', RHEA_TEXT_DOMAIN ) . ' ' . $from_name . ' ' . esc_html__( 'using contact form at', RHEA_TEXT_DOMAIN ) . ' ' . get_bloginfo( 'name' );

			/*
			 * Email Body
			 */
			$email_body = array();

			$email_body[] = array(
				'name'  => esc_html__( 'Name', RHEA_TEXT_DOMAIN ),
				'value' => $from_name,
			);

			$email_body[] = array(
				'name'  => esc_html__( 'Email', RHEA_TEXT_DOMAIN ),
				'value' => $from_email,
			);


			if ( ! empty( $phone_number ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Phone Number', RHEA_TEXT_DOMAIN ),
					'value' => $phone_number,
				);
			}

			if ( ! empty( $home_number ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Home Phone Number', RHEA_TEXT_DOMAIN ),
					'value' => $home_number,
				);
			}

			if ( ! empty( $office_number ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Office Phone Number', RHEA_TEXT_DOMAIN ),
					'value' => $office_number,
				);
			}

			if ( ! empty( $address ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Address', RHEA_TEXT_DOMAIN ),
					'value' => $address,
				);
			}
			if ( ! empty( $city ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'City', RHEA_TEXT_DOMAIN ),
					'value' => $city,
				);
			}
			if ( ! empty( $state ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Sate', RHEA_TEXT_DOMAIN ),
					'value' => $state,
				);
			}
			if ( ! empty( $zip ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Zip', RHEA_TEXT_DOMAIN ),
					'value' => $zip,
				);
			}
			if ( ! empty( $country ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Country', RHEA_TEXT_DOMAIN ),
					'value' => $country,
				);
			}
			if ( ! empty( $source ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Source', RHEA_TEXT_DOMAIN ),
					'value' => $source,
				);
			}
			if ( ! empty( $agent ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Agent', RHEA_TEXT_DOMAIN ),
					'value' => $agent,
				);
			}

			$email_body[] = array(
				'name'  => esc_html__( 'Message', RHEA_TEXT_DOMAIN ),
				'value' => $message,
			);

			if ( '1' == get_option( 'inspiry_gdpr_in_email', '0' ) && isset( $_POST['gdpr'] ) ) {
				$GDPR_agreement = $_POST['gdpr'];
				if ( ! empty( $GDPR_agreement ) ) {
					$email_body[] = array(
						'name'  => esc_html__( 'GDPR Agreement', RHEA_TEXT_DOMAIN ),
						'value' => $GDPR_agreement,
					);
				}
			}

			$email_body = custom_fields_to_email_body( $email_body );

			$email_body = ere_email_template( $email_body );

			/*
			 * Email Headers ( Reply To and Content Type )
			 */
			$headers = array();

			/* Send CC of contact form message if configured */
			$cc_email = sanitize_email( $_POST['target-email-cc'] );

			$cc_email = explode( ',', $cc_email );
			if ( ! empty( $cc_email ) ) {
				foreach ( $cc_email as $ind_email ) {
					$ind_email = sanitize_email( $ind_email );
					$ind_email = is_email( $ind_email );
					if ( $ind_email ) {
						$headers[] = "Cc: $ind_email";
					}
				}
			}

			/* Send BCC of contact form message if configured */
			$bcc_email = sanitize_email( $_POST['target-email-bcc'] );

			$bcc_email = explode( ',', $bcc_email );
			if ( ! empty( $bcc_email ) ) {
				foreach ( $bcc_email as $ind_email ) {
					$ind_email = sanitize_email( $ind_email );
					$ind_email = is_email( $ind_email );
					if ( $ind_email ) {
						$headers[] = "Bcc: $ind_email";
					}
				}
			}

			$headers[] = "Reply-To: $from_name <$from_email>";
			$headers[] = "Content-Type: text/html; charset=UTF-8";
			$headers   = apply_filters( "inspiry_contact_mail_header", $headers );    // just in case if you want to modify the header in child theme

			if ( wp_mail( $to_email, $email_subject, $email_body, $headers ) ) {

				if ( '1' === get_option( 'ere_contact_form_webhook_integration', '0' ) ) {
					ere_forms_safe_webhook_post( $_POST );
				}

				echo json_encode( array(
					'success' => true,
					'message' => esc_html__( 'Message Sent Successfully!', RHEA_TEXT_DOMAIN )
				) );
			} else {
				echo json_encode( array(
						'success' => false,
						'message' => esc_html__( 'Server Error: WordPress mail function failed!', RHEA_TEXT_DOMAIN )
					)
				);
			}

		else:
			echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Invalid Request !', RHEA_TEXT_DOMAIN )
				)
			);
		endif;

		do_action( 'rhea_after_inquiry_form_submit' );  // TODO: this hook is deprecated in 4.4.0 and following new added.
		do_action( 'rhea_after_inquiry_form_submission' );

		die;

	}

	add_action( 'wp_ajax_nopriv_rhea_inquiry_send_message', 'rhea_send_contact_message' );
	add_action( 'wp_ajax_rhea_inquiry_send_message', 'rhea_send_contact_message' );
}


if ( ! function_exists( 'rhea_schedule_property_tour' ) ) {
	/**
	 * Schedule a tour request handler
	 *
	 * @since 2.0.0
	 */
	function rhea_schedule_property_tour() {

		if ( isset( $_POST['sat-user-email'] ) ) {

			/* Verify Nonce */
			if ( ! isset( $_POST['rhea-sat-nonce'] ) || ! wp_verify_nonce( $_POST['rhea-sat-nonce'], 'rhea_schedule_a_tour_nonce' ) ) {
				echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Security verification failed, please refresh the page and try again.', RHEA_TEXT_DOMAIN )
				) );
				die;
			}

			$property_id = 0;
			if ( isset( $_POST['property-id'] ) ) {
				$property_id = $_POST['property-id'];
			}

			/* Verify Google reCAPTCHA */
			ere_verify_google_recaptcha();

			/**
			 * Setting target email based on user display type selection
			 *
			 * If display type is set to agent but agent email is not provided then property owner will
			 * receive the tour request.
			 **/
			if ( 0 < intval( $property_id ) ) {
				$user_type = get_post_meta( $property_id, 'REAL_HOMES_agent_display_option', true );
				$agents    = get_post_meta( $property_id, 'REAL_HOMES_agents' );
				if ( 'agent_info' == $user_type && ( is_array( $agents ) && 0 < count( $agents ) ) ) {
					$to_email = '';
					$first    = true;

					foreach ( $agents as $agent ) {
						$agent_email = get_post_meta( $agent, 'REAL_HOMES_agent_email', true );
						if ( ! empty( $agent_email ) && is_email( $agent_email ) ) {
							if ( $first ) {
								$first = false;
							} else {
								$to_email .= ',';
							}
							$to_email .= $agent_email;
						}
					}

				} else {
					$to_email = get_the_author_meta( 'email' );
				}

			}

			if ( empty ( $to_email ) ) {
				echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Target Email address is not properly configured!', RHEA_TEXT_DOMAIN )
				) );
				die;
			}

			/* Sanitize and Validate contact form input data */
			$from_name     = sanitize_text_field( $_POST['sat-user-name'] );
			$from_phone    = sanitize_text_field( $_POST['sat-user-phone'] );
			$message       = stripslashes( $_POST['sat-user-message'] );
			$selected_date = stripslashes( $_POST['sat-date'] );
			$selected_time = stripslashes( $_POST['sat-time'] );
			$tour_type     = stripslashes( $_POST['sat-tour-type'] );

			/* From email */
			$from_email = sanitize_email( $_POST['sat-user-email'] );
			$from_email = is_email( $from_email );
			if ( ! $from_email ) {
				echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Provided Email address is invalid!', RHEA_TEXT_DOMAIN )
				) );
				die;
			}

			/* Email Subject */
			$email_subject = esc_html__( 'Property Tour is requested by - ', RHEA_TEXT_DOMAIN ) . ' ' . $from_name . ' - ' . get_bloginfo( 'name' );

			/* Email body */
			$email_body = array();

			$property_title = get_the_title( $property_id );
			if ( ! empty( $property_title ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Property Title', RHEA_TEXT_DOMAIN ),
					'value' => $property_title,
				);
			}

			$property_permalink = get_permalink( $property_id );
			if ( ! empty( $property_permalink ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Property URL', RHEA_TEXT_DOMAIN ),
					'value' => $property_permalink,
				);
			}

			if ( ! empty( $selected_date ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Selected Date', RHEA_TEXT_DOMAIN ),
					'value' => $selected_date,
				);
			}

			if ( ! empty( $selected_time ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Selected Time', RHEA_TEXT_DOMAIN ),
					'value' => $selected_time,
				);
			}

			if ( ! empty( $tour_type ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Tour Type', RHEA_TEXT_DOMAIN ),
					'value' => $tour_type,
				);
			}

			if ( ! empty( $from_name ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Name', RHEA_TEXT_DOMAIN ),
					'value' => $from_name,
				);
			}

			$email_body[] = array(
				'name'  => esc_html__( 'Email', RHEA_TEXT_DOMAIN ),
				'value' => $from_email,
			);

			if ( ! empty( $from_phone ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Contact Number', RHEA_TEXT_DOMAIN ),
					'value' => $from_phone,
				);
			}

			if ( ! empty( $message ) ) {
				$email_body[] = array(
					'name'  => esc_html__( 'Message', RHEA_TEXT_DOMAIN ),
					'value' => $message,
				);
			}

			$email_body = ere_email_template( $email_body, 'schedule-a-tour' );

			/*
			 * Email Headers ( Reply To and Content Type )
			 */
			$headers   = array();
			$headers[] = "Reply-To: $from_email";
			$headers[] = "Content-Type: text/html; charset=UTF-8";
			$headers   = apply_filters( 'ere_schedule_tour_mail_header', $headers );    // just in case if you want to modify the header in child theme

			/* Send copy of message to admin if configured */
			if ( isset( $_POST['send-copy-to-admin'] ) && $_POST['send-copy-to-admin'] == 'yes' ) {

				if ( ! str_contains( $to_email, get_option( 'admin_email' ) ) ) {
					$admin_email = sanitize_email( get_option( 'admin_email' ) );
					$headers[]   = 'Cc: $admin_email';
				}
			}

			$current_scheduled_times = get_post_meta( $property_id, 'ere_property_scheduled_times', true );

			if ( ! is_array( $current_scheduled_times ) ) {
				$current_scheduled_times = array();
			}

			$current_scheduled_times[] = array(
				'selected_date' => $selected_date,
				'selected_time' => $selected_time,
				'schedule_type' => $tour_type,
				'user_name'     => $from_name,
				'user_phone'    => $from_phone,
				'user_email'    => $from_email,
				'user_message'  => $message
			);

			// Adding the tour request to related meta array stack
			update_post_meta( $property_id, 'ere_property_scheduled_times', $current_scheduled_times );

			// Sending email with requested tour information along with visitor's detail.
			if ( wp_mail( $to_email, $email_subject, $email_body, $headers ) ) {

				echo json_encode( array(
					'success' => true,
					'message' => esc_html__( 'Message Sent Successfully!', RHEA_TEXT_DOMAIN )
				) );

			} else {
				echo json_encode( array(
						'success' => false,
						'message' => esc_html__( 'Server Error: WordPress mail function failed!', RHEA_TEXT_DOMAIN )
					)
				);
			}

		} else {
			echo json_encode( array(
					'success' => false,
					'message' => esc_html__( 'Invalid Request!', RHEA_TEXT_DOMAIN )
				)
			);
		}

		do_action( 'rhea_after_schedule_tour_submit' );

		die;
	}

	add_action( 'wp_ajax_nopriv_rhea_schedule_a_tour', 'rhea_schedule_property_tour' );
	add_action( 'wp_ajax_rhea_schedule_a_tour', 'rhea_schedule_property_tour' );
}

if ( ! function_exists( 'rhea_search_widget_recursive' ) ) {
	/**
	 * Recursively search for widget settings by widget ID.
	 *
	 * This function traverses the Elementor data structure to locate the settings
	 * of a specific widget using its unique ID.
	 *
	 * @since 2.4.0
	 *
	 * @param array  $element   The array of Elementor elements to search within.
	 * @param string $widget_id The unique ID of the widget to search for.
	 *
	 * @return array|null The widget settings if found, or null if not found.
	 */
	function rhea_search_widget_recursive( $element, $widget_id ) {
		// Check if the current element's ID matches the given widget ID
		if ( isset( $element['id'] ) && $element['id'] === $widget_id ) {
			return isset( $element['settings'] ) ? $element['settings'] : null;
		}

		// Check if the element has child elements and search recursively
		if ( isset( $element['elements'] ) && is_array( $element['elements'] ) ) {
			foreach ( $element['elements'] as $child ) {
				$result = rhea_search_widget_recursive( $child, $widget_id );
				if ( $result !== null ) {
					return $result;
				}
			}
		}

		return null; // Widget not found in this branch
	}
}


if ( ! function_exists( 'rhea_properties_ajax_filter' ) ) {
	/**
	 * Filter Properties based on selection in Filters elementor widget
	 *
	 * @since 2.4.0
	 *
	 * @return string JSON
	 *
	 */
	function rhea_properties_ajax_filter() {

		global $settings, $widget_id, $properties_query, $column_classes;

		/* Confirming if necessary information is set */
		if ( ! isset( $_POST['filterValues'] ) ) {
            return;
		}

		$search_args            = rhea_prepare_filter_widget_args( $_POST['filterValues'] );
		$search_values          = $_POST['filterValues'];
		$properties_query       = new WP_Query( $search_args );
		$widget_id              = ! empty( $search_values['target_widget_id'] ) ? $search_values['target_widget_id'] : '';
		$target_widget_name     = ! empty( $_POST['widget_name'] ) ? $_POST['widget_name'] : '';
		$target_widget_settings = $_POST['target_widget_settings'];
		$pagination_inner_class = 'rh_filter_pagination';
		$layout                 = 'list';
		$search_results         = '';
		$pagination             = '';

		// If specific card is set for this request
		if ( ! empty( $search_values['card_variation'] ) ) {
			$settings['card'] = $search_values['card_variation'];
		}

        if ( ! empty( $search_values[ 'current-layout' ] ) ) {
	        $layout = $search_values[ 'current-layout' ];
        } else if ( $target_widget_settings['layout'] ) {
			$layout = $target_widget_settings['layout'];
		} else {
			$target_widget_settings = 'carousel';
		}

		if ( in_array( $layout, array( 'grid', 'list' ) ) ) {
			$column_classes = rhea_generate_column_classes( $layout, $target_widget_settings );
		}

		$pagination_trigger = filter_var( $search_values['pagination_trigger'] ?? false, FILTER_VALIDATE_BOOLEAN );

		ob_start();

		if ( $properties_query->have_posts() ) {

			if ( 'rh-properties-widget-v14' === $target_widget_name ) {
				if ( 'carousel' !== $layout ) {
					while ( $properties_query->have_posts() ) {
						$properties_query->the_post();

						$property_id      = get_the_ID();
						$args             = array();
						$args['layout']   = $layout;
						$args['slide']    = false;
						$args['settings'] = $target_widget_settings;

						rhea_properties_widget_v14_card( $property_id, $args );
					}

					$search_results = ob_get_clean();

					wp_reset_postdata();
				}

				if ( 'yes' == $target_widget_settings['show_pagination'] && ! $pagination_trigger ) {

					ob_start();
					?>
                    <div class="rh-properties-widget-v14-svg-loader rhea-pagination-loader">
						<?php include RHEA_ASSETS_DIR . '/icons/loading-bars.svg'; ?>
                    </div>
					<?php
					RHEA_ajax_pagination( $properties_query->max_num_pages, $properties_query, 'rh-properties-widget-v14-pagination', false );
					$pagination = ob_get_clean();
				}
			}

			wp_send_json_success(
				array(
					'search_results'   => $search_results,
					'pagination'       => $pagination,
					'status'           => ob_end_clean(),
					'max_pages'        => $properties_query->max_num_pages,
					'search_query'     => $properties_query,
					'total_properties' => $properties_query->found_posts
				)
			);

		} else {

			realhomes_print_no_result();
			$search_results = ob_get_contents();

			wp_send_json_success(
				array(
					'search_results' => $search_results,
					'search_query'   => $properties_query,
					'status'         => ob_end_clean()
				)
			);

		}

		die;

	}

	add_action( 'wp_ajax_nopriv_rhea_properties_ajax_filter', 'rhea_properties_ajax_filter' );
	add_action( 'wp_ajax_rhea_properties_ajax_filter', 'rhea_properties_ajax_filter' );
}

/**
 * Retrieve the CSS column classes based on the specified layout.
 *
 * @since 2.3.0
 *
 * @param string $layout         The layout identifier.
 * @param string $default_column The column identifier.
 *
 * @return string The CSS classes for the grid or list columns.
 */
function rhea_generate_column_classes( $layout, $settings = array(), $devices = null, $default_column = '' ) {
	// Fallback devices if none are provided
	if ( $devices === null ) {
		$devices = array(
			"widescreen",
			"laptop",
			"tablet_extra",
			"tablet",
			"mobile_extra",
			"mobile",
		);
	}

	if ( 'carousel' !== $layout ) {
		$setting_id = "{$layout}_columns";
	}

	// Start building the class prefix
	$class_prefix      = sprintf( 'rhea-ultra-properties-%s', str_replace( '_', '-', esc_html( $setting_id ) ) );
	$container_classes = array( $class_prefix );

	// Handle default column logic
	if ( isset( $settings[ $setting_id ] ) && ! empty( $settings[ $setting_id ] ) ) {
		$default_column = $settings[ $setting_id ];
	}

	// Default column class
	$container_classes[] = $class_prefix . '-' . esc_html( $default_column );

	// Iterate through devices to add device-specific classes
	foreach ( $devices as $device ) {
		$id = $setting_id . '_' . $device;
		if ( isset( $settings[ $id ] ) && ! empty( $settings[ $id ] ) ) {
			$container_classes[] = $class_prefix . '-' . esc_html( $device ) . '-' . esc_html( $settings[ $id ] );
		}
	}

	// Return the classes as a space-separated string
	return join( ' ', $container_classes );
}

if ( ! function_exists( 'rhea_get_total_property_views' ) ) {
	/**
	 * Get total views for a specific property.
	 *
	 * @since 2.4.2
	 *
	 * @param int $property_id
	 * @return int
	 */
	function rhea_get_total_property_views( $property_id ) {
		if ( ! $property_id ) {
			return 0;
		}

		global $wpdb;
		$table_name = $wpdb->prefix . 'inspiry_property_analytics';

		// Check if the table exists
		if ( $wpdb->get_var( "SHOW TABLES LIKE '{$table_name}'" ) !== $table_name ) {
			return 0;
		}

		return (int) $wpdb->get_var( $wpdb->prepare(
			"SELECT COUNT(*) FROM $table_name WHERE PID = %d",
			$property_id
		) );
	}
}
