<?php

/**
 * Trait RHEA_GDPR_Controls
 *
 * Trait for GDPR field in forms
 *
 * @since 2.4.0
 */
trait RHEA_GDPR_Controls {
	/**
	 * gdpr_settings
	 *
	 * Add GDPR field related controls into forms
	 *
	 * @since 2.4.0
	 */
	public function gdpr_settings() {

		$this->start_controls_section(
			'inquiry-gdpr-settings',
			[
				'label' => esc_html__( 'GDPR Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'gdpr_required_typography',
				'label'    => esc_html__( 'GDPR Label', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .gdpr-checkbox-label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'gdpr_required_postfix_typography',
				'label'    => esc_html__( 'GDPR Label Asterisk (*)', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .gdpr-checkbox-label .required-label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'gdpr_text_typography',
				'label'    => esc_html__( 'GDPR Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_inspiry_gdpr .rh-gdpr-text-inner-wrapper',
			]
		);

		$this->add_control(
			'gdpr-required-label',
			[
				'label'     => esc_html__( 'GDPR Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gdpr-checkbox-label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'gdpr-required-label-postfix',
			[
				'label'     => esc_html__( 'GDPR Label Asterisk (*)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gdpr-checkbox-label .required-label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'gdpr-text-color',
			[
				'label'     => esc_html__( 'GDPR Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_inspiry_gdpr label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'checkbox-border-color',
			[
				'label'     => esc_html__( 'Checkbox Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_inspiry_gdpr label:before' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'checkbox-checked-border-color',
			[
				'label'     => esc_html__( 'Checkbox Checked Border/Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_inspiry_gdpr input:checked + label:before' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rh_inspiry_gdpr input:checked + label:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'checkbox-checked-tick-color',
			[
				'label'     => esc_html__( 'Checkbox Checked Tick Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_inspiry_gdpr input:checked + label:before' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'gdpr-label-padding',
			[
				'label'      => esc_html__( 'GDPR Label Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_inspiry_gdpr .gdpr-checkbox-label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'gdpr-checkbox-padding',
			[
				'label'      => esc_html__( 'GDPR Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_inspiry_gdpr label[for=rh_inspiry_gdpr]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'gdpr-checkbox-margin',
			[
				'label'      => esc_html__( 'GDPR Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_inspiry_gdpr label[for=rh_inspiry_gdpr]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'gdpr-checkbox-tick-margin',
			[
				'label'      => esc_html__( 'Checkbox Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_inspiry_gdpr label[for=rh_inspiry_gdpr]:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'gdpr-fields-heading',
			[
				'label'     => esc_html__( 'Fields Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => '',
			]
		);

		$this->add_responsive_control(
			'gdpr-fields_border_radius',
			[
				'label' => esc_html__( 'Fields Border Radius', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::SLIDER,

				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_inspiry_gdpr label[for=rh_inspiry_gdpr]' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'gdpr-field-border',
				'label'    => esc_html__( 'Fields Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh_inspiry_gdpr label[for=rh_inspiry_gdpr]',
			]
		);

		$this->add_control(
			'gdpr-border-color-error',
			[
				'label'     => esc_html__( 'Invalid Required Field Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_inspiry_gdpr .error+label[for=rh_inspiry_gdpr]' => 'border-color: {{VALUE}} !important',
				],
			]
		);


		$this->end_controls_section();

	}

}